package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EventHookFilterMapObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The optional filter defined on a specific event type &gt; **Note:** Event hook filters is a [self-service Early
 * Access (EA)](/openapi/okta-management/guides/release-lifecycle/#early-access-ea) to enable. If you want to disable
 * this feature, it&#39;s recommended to first remove all event filters.
 */
@ApiModel(description = "The optional filter defined on a specific event type  > **Note:** Event hook filters is a [self-service Early Access (EA)](/openapi/okta-management/guides/release-lifecycle/#early-access-ea) to enable. If you want to disable this feature, it's recommended to first remove all event filters.")
@JsonPropertyOrder({ EventHookFilters.JSON_PROPERTY_EVENT_FILTER_MAP, EventHookFilters.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class EventHookFilters implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EVENT_FILTER_MAP = "eventFilterMap";
    private List<EventHookFilterMapObject> eventFilterMap = null;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public EventHookFilters() {
    }

    /*
     * @JsonCreator public EventHookFilters(
     *
     * @JsonProperty(JSON_PROPERTY_TYPE) String type ) { this(); this.type = type; }
     */

    public EventHookFilters eventFilterMap(List<EventHookFilterMapObject> eventFilterMap) {

        this.eventFilterMap = eventFilterMap;
        return this;
    }

    public EventHookFilters addeventFilterMapItem(EventHookFilterMapObject eventFilterMapItem) {
        if (this.eventFilterMap == null) {
            this.eventFilterMap = new ArrayList<>();
        }
        this.eventFilterMap.add(eventFilterMapItem);
        return this;
    }

    /**
     * The object that maps the filter to the event type
     *
     * @return eventFilterMap
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The object that maps the filter to the event type")
    @JsonProperty(JSON_PROPERTY_EVENT_FILTER_MAP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<EventHookFilterMapObject> getEventFilterMap() {
        return eventFilterMap;
    }

    @JsonProperty(JSON_PROPERTY_EVENT_FILTER_MAP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEventFilterMap(List<EventHookFilterMapObject> eventFilterMap) {
        this.eventFilterMap = eventFilterMap;
    }

    /**
     * The type of filter. Currently only supports &#x60;EXPRESSION_LANGUAGE&#x60;
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The type of filter. Currently only supports `EXPRESSION_LANGUAGE`")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EventHookFilters eventHookFilters = (EventHookFilters) o;
        return Objects.equals(this.eventFilterMap, eventHookFilters.eventFilterMap)
                && Objects.equals(this.type, eventHookFilters.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(eventFilterMap, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventHookFilters {\n");
        sb.append("    eventFilterMap: ").append(toIndentedString(eventFilterMap)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
