package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.DeviceDisplayName;
import com.okta.sdk.resource.model.DeviceProfile;
import com.okta.sdk.resource.model.DeviceStatus;
import com.okta.sdk.resource.model.LinksSelfAndFullUsersLifecycle;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Device
 */
@JsonPropertyOrder({ Device.JSON_PROPERTY_CREATED, Device.JSON_PROPERTY_ID, Device.JSON_PROPERTY_LAST_UPDATED,
        Device.JSON_PROPERTY_PROFILE, Device.JSON_PROPERTY_RESOURCE_ALTERNATE_ID,
        Device.JSON_PROPERTY_RESOURCE_DISPLAY_NAME, Device.JSON_PROPERTY_RESOURCE_ID,
        Device.JSON_PROPERTY_RESOURCE_TYPE, Device.JSON_PROPERTY_STATUS, Device.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class Device implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private DeviceProfile profile;

    public static final String JSON_PROPERTY_RESOURCE_ALTERNATE_ID = "resourceAlternateId";
    private String resourceAlternateId;

    public static final String JSON_PROPERTY_RESOURCE_DISPLAY_NAME = "resourceDisplayName";
    private DeviceDisplayName resourceDisplayName;

    public static final String JSON_PROPERTY_RESOURCE_ID = "resourceId";
    private String resourceId;

    public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
    private String resourceType = "UDDevice";

    public static final String JSON_PROPERTY_STATUS = "status";
    private DeviceStatus status;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelfAndFullUsersLifecycle links;

    public Device() {
    }

    /*
     * @JsonCreator public Device(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_RESOURCE_ALTERNATE_ID) String resourceAlternateId,
     *
     * @JsonProperty(JSON_PROPERTY_RESOURCE_ID) String resourceId,
     *
     * @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE) String resourceType ) { this(); this.created = created; this.id = id;
     * this.lastUpdated = lastUpdated; this.resourceAlternateId = resourceAlternateId; this.resourceId = resourceId;
     * this.resourceType = resourceType; }
     */

    /**
     * Timestamp when the device was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the device was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * Unique key for the device
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique key for the device")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the device record was last updated. Updates occur when Okta collects and saves device signals
     * during authentication, and when the lifecycle state of the device changes.
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the device record was last updated. Updates occur when Okta collects and saves device signals during authentication, and when the lifecycle state of the device changes.")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public Device profile(DeviceProfile profile) {

        this.profile = profile;
        return this;
    }

    /**
     * Get profile
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DeviceProfile getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(DeviceProfile profile) {
        this.profile = profile;
    }

    /**
     * Get resourceAlternateId
     *
     * @return resourceAlternateId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RESOURCE_ALTERNATE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getResourceAlternateId() {
        return resourceAlternateId;
    }

    public Device resourceDisplayName(DeviceDisplayName resourceDisplayName) {

        this.resourceDisplayName = resourceDisplayName;
        return this;
    }

    /**
     * Get resourceDisplayName
     *
     * @return resourceDisplayName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RESOURCE_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DeviceDisplayName getResourceDisplayName() {
        return resourceDisplayName;
    }

    @JsonProperty(JSON_PROPERTY_RESOURCE_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResourceDisplayName(DeviceDisplayName resourceDisplayName) {
        this.resourceDisplayName = resourceDisplayName;
    }

    /**
     * Alternate key for the &#x60;id&#x60;
     *
     * @return resourceId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Alternate key for the `id`")
    @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getResourceId() {
        return resourceId;
    }

    /**
     * Get resourceType
     *
     * @return resourceType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getResourceType() {
        return resourceType;
    }

    public Device status(DeviceStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DeviceStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(DeviceStatus status) {
        this.status = status;
    }

    public Device links(LinksSelfAndFullUsersLifecycle links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelfAndFullUsersLifecycle getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelfAndFullUsersLifecycle links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device) o;
        return Objects.equals(this.created, device.created) && Objects.equals(this.id, device.id)
                && Objects.equals(this.lastUpdated, device.lastUpdated) && Objects.equals(this.profile, device.profile)
                && Objects.equals(this.resourceAlternateId, device.resourceAlternateId)
                && Objects.equals(this.resourceDisplayName, device.resourceDisplayName)
                && Objects.equals(this.resourceId, device.resourceId)
                && Objects.equals(this.resourceType, device.resourceType) && Objects.equals(this.status, device.status)
                && Objects.equals(this.links, device.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, id, lastUpdated, profile, resourceAlternateId, resourceDisplayName, resourceId,
                resourceType, status, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Device {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    resourceAlternateId: ").append(toIndentedString(resourceAlternateId)).append("\n");
        sb.append("    resourceDisplayName: ").append(toIndentedString(resourceDisplayName)).append("\n");
        sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
        sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
