package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ContentSecurityPolicySetting
 */
@JsonPropertyOrder({ ContentSecurityPolicySetting.JSON_PROPERTY_MODE,
        ContentSecurityPolicySetting.JSON_PROPERTY_REPORT_URI, ContentSecurityPolicySetting.JSON_PROPERTY_SRC_LIST })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ContentSecurityPolicySetting implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Gets or Sets mode
     */
    public enum ModeEnum {
        ENFORCED(String.valueOf("enforced")),

        REPORT_ONLY(String.valueOf("report_only")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_MODE = "mode";
    private ModeEnum mode;

    public static final String JSON_PROPERTY_REPORT_URI = "reportUri";
    private String reportUri;

    public static final String JSON_PROPERTY_SRC_LIST = "srcList";
    private List<String> srcList = null;

    public ContentSecurityPolicySetting() {
    }

    public ContentSecurityPolicySetting mode(ModeEnum mode) {

        this.mode = mode;
        return this;
    }

    /**
     * Get mode
     *
     * @return mode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ModeEnum getMode() {
        return mode;
    }

    @JsonProperty(JSON_PROPERTY_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public ContentSecurityPolicySetting reportUri(String reportUri) {

        this.reportUri = reportUri;
        return this;
    }

    /**
     * Get reportUri
     *
     * @return reportUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REPORT_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getReportUri() {
        return reportUri;
    }

    @JsonProperty(JSON_PROPERTY_REPORT_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReportUri(String reportUri) {
        this.reportUri = reportUri;
    }

    public ContentSecurityPolicySetting srcList(List<String> srcList) {

        this.srcList = srcList;
        return this;
    }

    public ContentSecurityPolicySetting addsrcListItem(String srcListItem) {
        if (this.srcList == null) {
            this.srcList = new ArrayList<>();
        }
        this.srcList.add(srcListItem);
        return this;
    }

    /**
     * Get srcList
     *
     * @return srcList
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SRC_LIST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getSrcList() {
        return srcList;
    }

    @JsonProperty(JSON_PROPERTY_SRC_LIST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSrcList(List<String> srcList) {
        this.srcList = srcList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ContentSecurityPolicySetting contentSecurityPolicySetting = (ContentSecurityPolicySetting) o;
        return Objects.equals(this.mode, contentSecurityPolicySetting.mode)
                && Objects.equals(this.reportUri, contentSecurityPolicySetting.reportUri)
                && Objects.equals(this.srcList, contentSecurityPolicySetting.srcList);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(mode, reportUri, srcList);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentSecurityPolicySetting {\n");
        sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
        sb.append("    reportUri: ").append(toIndentedString(reportUri)).append("\n");
        sb.append("    srcList: ").append(toIndentedString(srcList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
