package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEventReasonAdmin;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEventReasonUser;
import com.okta.sdk.resource.model.SecurityEventSubject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The subject&#39;s device compliance was revoked
 */
@ApiModel(description = "The subject's device compliance was revoked")
@JsonPropertyOrder({ CaepDeviceComplianceChangeEvent.JSON_PROPERTY_CURRENT_STATUS,
        CaepDeviceComplianceChangeEvent.JSON_PROPERTY_EVENT_TIMESTAMP,
        CaepDeviceComplianceChangeEvent.JSON_PROPERTY_INITIATING_ENTITY,
        CaepDeviceComplianceChangeEvent.JSON_PROPERTY_PREVIOUS_STATUS,
        CaepDeviceComplianceChangeEvent.JSON_PROPERTY_REASON_ADMIN,
        CaepDeviceComplianceChangeEvent.JSON_PROPERTY_REASON_USER,
        CaepDeviceComplianceChangeEvent.JSON_PROPERTY_SUBJECT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class CaepDeviceComplianceChangeEvent implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Current device compliance status
     */
    public enum CurrentStatusEnum {
        COMPLIANT(String.valueOf("compliant")),

        NOT_COMPLIANT(String.valueOf("not-compliant")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        CurrentStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static CurrentStatusEnum fromValue(String value) {
            for (CurrentStatusEnum b : CurrentStatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_CURRENT_STATUS = "current_status";
    private CurrentStatusEnum currentStatus;

    public static final String JSON_PROPERTY_EVENT_TIMESTAMP = "event_timestamp";
    private Long eventTimestamp;

    /**
     * The entity that initiated the event
     */
    public enum InitiatingEntityEnum {
        ADMIN(String.valueOf("admin")),

        USER(String.valueOf("user")),

        POLICY(String.valueOf("policy")),

        SYSTEM(String.valueOf("system")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        InitiatingEntityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static InitiatingEntityEnum fromValue(String value) {
            for (InitiatingEntityEnum b : InitiatingEntityEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_INITIATING_ENTITY = "initiating_entity";
    private InitiatingEntityEnum initiatingEntity;

    /**
     * Previous device compliance status
     */
    public enum PreviousStatusEnum {
        COMPLIANT(String.valueOf("compliant")),

        NOT_COMPLIANT(String.valueOf("not-compliant")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        PreviousStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static PreviousStatusEnum fromValue(String value) {
            for (PreviousStatusEnum b : PreviousStatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_PREVIOUS_STATUS = "previous_status";
    private PreviousStatusEnum previousStatus;

    public static final String JSON_PROPERTY_REASON_ADMIN = "reason_admin";
    private CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin;

    public static final String JSON_PROPERTY_REASON_USER = "reason_user";
    private CaepDeviceComplianceChangeEventReasonUser reasonUser;

    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private SecurityEventSubject subject;

    public CaepDeviceComplianceChangeEvent() {
    }

    public CaepDeviceComplianceChangeEvent currentStatus(CurrentStatusEnum currentStatus) {

        this.currentStatus = currentStatus;
        return this;
    }

    /**
     * Current device compliance status
     *
     * @return currentStatus
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "non-compliant", required = true, value = "Current device compliance status")
    @JsonProperty(JSON_PROPERTY_CURRENT_STATUS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public CurrentStatusEnum getCurrentStatus() {
        return currentStatus;
    }

    @JsonProperty(JSON_PROPERTY_CURRENT_STATUS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setCurrentStatus(CurrentStatusEnum currentStatus) {
        this.currentStatus = currentStatus;
    }

    public CaepDeviceComplianceChangeEvent eventTimestamp(Long eventTimestamp) {

        this.eventTimestamp = eventTimestamp;
        return this;
    }

    /**
     * The time of the event (UNIX timestamp)
     *
     * @return eventTimestamp
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "1702448550", required = true, value = "The time of the event (UNIX timestamp)")
    @JsonProperty(JSON_PROPERTY_EVENT_TIMESTAMP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public Long getEventTimestamp() {
        return eventTimestamp;
    }

    @JsonProperty(JSON_PROPERTY_EVENT_TIMESTAMP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public CaepDeviceComplianceChangeEvent initiatingEntity(InitiatingEntityEnum initiatingEntity) {

        this.initiatingEntity = initiatingEntity;
        return this;
    }

    /**
     * The entity that initiated the event
     *
     * @return initiatingEntity
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The entity that initiated the event")
    @JsonProperty(JSON_PROPERTY_INITIATING_ENTITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public InitiatingEntityEnum getInitiatingEntity() {
        return initiatingEntity;
    }

    @JsonProperty(JSON_PROPERTY_INITIATING_ENTITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInitiatingEntity(InitiatingEntityEnum initiatingEntity) {
        this.initiatingEntity = initiatingEntity;
    }

    public CaepDeviceComplianceChangeEvent previousStatus(PreviousStatusEnum previousStatus) {

        this.previousStatus = previousStatus;
        return this;
    }

    /**
     * Previous device compliance status
     *
     * @return previousStatus
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Previous device compliance status")
    @JsonProperty(JSON_PROPERTY_PREVIOUS_STATUS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public PreviousStatusEnum getPreviousStatus() {
        return previousStatus;
    }

    @JsonProperty(JSON_PROPERTY_PREVIOUS_STATUS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setPreviousStatus(PreviousStatusEnum previousStatus) {
        this.previousStatus = previousStatus;
    }

    public CaepDeviceComplianceChangeEvent reasonAdmin(CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin) {

        this.reasonAdmin = reasonAdmin;
        return this;
    }

    /**
     * Get reasonAdmin
     *
     * @return reasonAdmin
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REASON_ADMIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CaepDeviceComplianceChangeEventReasonAdmin getReasonAdmin() {
        return reasonAdmin;
    }

    @JsonProperty(JSON_PROPERTY_REASON_ADMIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReasonAdmin(CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin) {
        this.reasonAdmin = reasonAdmin;
    }

    public CaepDeviceComplianceChangeEvent reasonUser(CaepDeviceComplianceChangeEventReasonUser reasonUser) {

        this.reasonUser = reasonUser;
        return this;
    }

    /**
     * Get reasonUser
     *
     * @return reasonUser
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REASON_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CaepDeviceComplianceChangeEventReasonUser getReasonUser() {
        return reasonUser;
    }

    @JsonProperty(JSON_PROPERTY_REASON_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReasonUser(CaepDeviceComplianceChangeEventReasonUser reasonUser) {
        this.reasonUser = reasonUser;
    }

    public CaepDeviceComplianceChangeEvent subject(SecurityEventSubject subject) {

        this.subject = subject;
        return this;
    }

    /**
     * Get subject
     *
     * @return subject
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public SecurityEventSubject getSubject() {
        return subject;
    }

    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSubject(SecurityEventSubject subject) {
        this.subject = subject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CaepDeviceComplianceChangeEvent caepDeviceComplianceChangeEvent = (CaepDeviceComplianceChangeEvent) o;
        return Objects.equals(this.currentStatus, caepDeviceComplianceChangeEvent.currentStatus)
                && Objects.equals(this.eventTimestamp, caepDeviceComplianceChangeEvent.eventTimestamp)
                && Objects.equals(this.initiatingEntity, caepDeviceComplianceChangeEvent.initiatingEntity)
                && Objects.equals(this.previousStatus, caepDeviceComplianceChangeEvent.previousStatus)
                && Objects.equals(this.reasonAdmin, caepDeviceComplianceChangeEvent.reasonAdmin)
                && Objects.equals(this.reasonUser, caepDeviceComplianceChangeEvent.reasonUser)
                && Objects.equals(this.subject, caepDeviceComplianceChangeEvent.subject);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(currentStatus, eventTimestamp, initiatingEntity, previousStatus, reasonAdmin, reasonUser,
                subject);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CaepDeviceComplianceChangeEvent {\n");
        sb.append("    currentStatus: ").append(toIndentedString(currentStatus)).append("\n");
        sb.append("    eventTimestamp: ").append(toIndentedString(eventTimestamp)).append("\n");
        sb.append("    initiatingEntity: ").append(toIndentedString(initiatingEntity)).append("\n");
        sb.append("    previousStatus: ").append(toIndentedString(previousStatus)).append("\n");
        sb.append("    reasonAdmin: ").append(toIndentedString(reasonAdmin)).append("\n");
        sb.append("    reasonUser: ").append(toIndentedString(reasonUser)).append("\n");
        sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
