package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CustomAppUserVerificationEnum;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticatorKeyCustomAppAllOfSettings
 */
@JsonPropertyOrder({ AuthenticatorKeyCustomAppAllOfSettings.JSON_PROPERTY_USER_VERIFICATION,
        AuthenticatorKeyCustomAppAllOfSettings.JSON_PROPERTY_APP_INSTANCE_ID })
@JsonTypeName("AuthenticatorKeyCustomApp_allOf_settings")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AuthenticatorKeyCustomAppAllOfSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_USER_VERIFICATION = "userVerification";
    private CustomAppUserVerificationEnum userVerification;

    public static final String JSON_PROPERTY_APP_INSTANCE_ID = "appInstanceId";
    private String appInstanceId;

    public AuthenticatorKeyCustomAppAllOfSettings() {
    }

    public AuthenticatorKeyCustomAppAllOfSettings userVerification(CustomAppUserVerificationEnum userVerification) {

        this.userVerification = userVerification;
        return this;
    }

    /**
     * Get userVerification
     *
     * @return userVerification
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER_VERIFICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CustomAppUserVerificationEnum getUserVerification() {
        return userVerification;
    }

    @JsonProperty(JSON_PROPERTY_USER_VERIFICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserVerification(CustomAppUserVerificationEnum userVerification) {
        this.userVerification = userVerification;
    }

    public AuthenticatorKeyCustomAppAllOfSettings appInstanceId(String appInstanceId) {

        this.appInstanceId = appInstanceId;
        return this;
    }

    /**
     * The application instance ID. For custom_app, you need to create an OIDC native app using the [Apps
     * API](https://developer.okta.com/docs/reference/api/apps/) with &#x60;Authorization Code&#x60; and &#x60;Refresh
     * Token&#x60; grant types. You can leave both &#x60;Sign-in redirect URIs&#x60; and &#x60;Sign-out redirect
     * URIs&#x60; as the default values.
     *
     * @return appInstanceId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The application instance ID. For custom_app, you need to create an OIDC native app using the [Apps API](https://developer.okta.com/docs/reference/api/apps/) with `Authorization Code` and `Refresh Token` grant types. You can leave both `Sign-in redirect URIs` and `Sign-out redirect URIs` as the default values.")
    @JsonProperty(JSON_PROPERTY_APP_INSTANCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAppInstanceId() {
        return appInstanceId;
    }

    @JsonProperty(JSON_PROPERTY_APP_INSTANCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAppInstanceId(String appInstanceId) {
        this.appInstanceId = appInstanceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorKeyCustomAppAllOfSettings authenticatorKeyCustomAppAllOfSettings = (AuthenticatorKeyCustomAppAllOfSettings) o;
        return Objects.equals(this.userVerification, authenticatorKeyCustomAppAllOfSettings.userVerification)
                && Objects.equals(this.appInstanceId, authenticatorKeyCustomAppAllOfSettings.appInstanceId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(userVerification, appInstanceId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorKeyCustomAppAllOfSettings {\n");
        sb.append("    userVerification: ").append(toIndentedString(userVerification)).append("\n");
        sb.append("    appInstanceId: ").append(toIndentedString(appInstanceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
