package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The user&#39;s password. This is a write-only property. An empty &#x60;password&#x60; object is returned to indicate
 * that a password value exists.
 */
@ApiModel(description = "The user's password. This is a write-only property. An empty `password` object is returned to indicate that a password value exists.")
@JsonPropertyOrder({ AppUserPasswordCredential.JSON_PROPERTY_VALUE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AppUserPasswordCredential implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public AppUserPasswordCredential() {
    }

    public AppUserPasswordCredential value(String value) {

        this.value = value;
        return this;
    }

    /**
     * Password value
     *
     * @return value
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Password value")
    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getValue() {
        return value;
    }

    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AppUserPasswordCredential appUserPasswordCredential = (AppUserPasswordCredential) o;
        return Objects.equals(this.value, appUserPasswordCredential.value);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppUserPasswordCredential {\n");
        sb.append("    value: ").append(toIndentedString(value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
