/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.UserActivationToken;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserLifecycleApi {

    private ApiClient apiClient;

    public UserLifecycleApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserLifecycleApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate a User Activates a User. This operation can only be performed on Users with a &#x60;STAGED&#x60; or
     * &#x60;DEPROVISIONED&#x60; status. Activation of a User is an asynchronous operation. * The User will have the
     * &#x60;transitioningToStatus&#x60; property with an &#x60;ACTIVE&#x60; value during activation to indicate that
     * the user hasn&#39;t completed the asynchronous operation. * The User will have an &#x60;ACTIVE&#x60; status when
     * the activation process completes. Users who don&#39;t have a password must complete the welcome flow by visiting
     * the activation link to complete the transition to &#x60;ACTIVE&#x60; status. &gt; **Note:** If you want to send a
     * branded User Activation email, change the subdomain of your request to the custom domain that&#39;s associated
     * with the brand. &gt; For example, change &#x60;subdomain.okta.com&#x60; to &#x60;custom.domain.one&#x60;. See
     * [Multibrand and custom domains](https://developer.okta.com/docs/concepts/brands/#multibrand-and-custom-domains).
     * &gt; **Note:** If you have Optional Password enabled, visiting the activation link is optional for users who
     * aren&#39;t required to enroll a password. &gt; See [Create user with Optional Password
     * enabled](https://developer.okta.com/docs/reference/api/users/#create-user-with-optional-password-enabled). &gt;
     * **Legal disclaimer** &gt; After a user is added to the Okta directory, they receive an activation email. As part
     * of signing up for this service, &gt; you agreed not to use Okta&#39;s service/product to spam and/or send
     * unsolicited messages. &gt; Please refrain from adding unrelated accounts to the directory as Okta is not
     * responsible for, and disclaims any and all &gt; liability associated with, the activation email&#39;s content.
     * You, and you alone, bear responsibility for the emails sent to any recipients.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param sendEmail
     *            Sends an activation email to the user if &#x60;true&#x60; (optional, default to true)
     *
     * @return UserActivationToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserActivationToken activateUser(String userId, Boolean sendEmail) throws ApiException {
        return this.activateUser(userId, sendEmail, Collections.emptyMap());
    }

    /**
     * Activate a User Activates a User. This operation can only be performed on Users with a &#x60;STAGED&#x60; or
     * &#x60;DEPROVISIONED&#x60; status. Activation of a User is an asynchronous operation. * The User will have the
     * &#x60;transitioningToStatus&#x60; property with an &#x60;ACTIVE&#x60; value during activation to indicate that
     * the user hasn&#39;t completed the asynchronous operation. * The User will have an &#x60;ACTIVE&#x60; status when
     * the activation process completes. Users who don&#39;t have a password must complete the welcome flow by visiting
     * the activation link to complete the transition to &#x60;ACTIVE&#x60; status. &gt; **Note:** If you want to send a
     * branded User Activation email, change the subdomain of your request to the custom domain that&#39;s associated
     * with the brand. &gt; For example, change &#x60;subdomain.okta.com&#x60; to &#x60;custom.domain.one&#x60;. See
     * [Multibrand and custom domains](https://developer.okta.com/docs/concepts/brands/#multibrand-and-custom-domains).
     * &gt; **Note:** If you have Optional Password enabled, visiting the activation link is optional for users who
     * aren&#39;t required to enroll a password. &gt; See [Create user with Optional Password
     * enabled](https://developer.okta.com/docs/reference/api/users/#create-user-with-optional-password-enabled). &gt;
     * **Legal disclaimer** &gt; After a user is added to the Okta directory, they receive an activation email. As part
     * of signing up for this service, &gt; you agreed not to use Okta&#39;s service/product to spam and/or send
     * unsolicited messages. &gt; Please refrain from adding unrelated accounts to the directory as Okta is not
     * responsible for, and disclaims any and all &gt; liability associated with, the activation email&#39;s content.
     * You, and you alone, bear responsibility for the emails sent to any recipients.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param sendEmail
     *            Sends an activation email to the user if &#x60;true&#x60; (optional, default to true)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserActivationToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserActivationToken activateUser(String userId, Boolean sendEmail, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling activateUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/lifecycle/activate".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("sendEmail", sendEmail));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserActivationToken> localVarReturnType = new TypeReference<UserActivationToken>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate a User Deactivates a User. This operation can only be performed on Users that do not have a
     * &#x60;DEPROVISIONED&#x60; status. * The User&#39;s &#x60;transitioningToStatus&#x60; property is
     * &#x60;DEPROVISIONED&#x60; during deactivation to indicate that the user hasn&#39;t completed the asynchronous
     * operation. * The User&#39;s status is &#x60;DEPROVISIONED&#x60; when the deactivation process is complete. &gt;
     * **Important:** Deactivating a User is a **destructive** operation. The User is deprovisioned from all assigned
     * apps, which might destroy their data such as email or files. **This action cannot be recovered!** You can also
     * perform user deactivation asynchronously. To invoke asynchronous user deactivation, pass an HTTP header
     * &#x60;Prefer: respond-async&#x60; with the request.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param sendEmail
     *            Sends a deactivation email to the admin if &#x60;true&#x60; (optional, default to false)
     * @param prefer
     *            Request asynchronous processing (optional)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateUser(String userId, Boolean sendEmail, String prefer) throws ApiException {
        this.deactivateUser(userId, sendEmail, prefer, Collections.emptyMap());
    }

    /**
     * Deactivate a User Deactivates a User. This operation can only be performed on Users that do not have a
     * &#x60;DEPROVISIONED&#x60; status. * The User&#39;s &#x60;transitioningToStatus&#x60; property is
     * &#x60;DEPROVISIONED&#x60; during deactivation to indicate that the user hasn&#39;t completed the asynchronous
     * operation. * The User&#39;s status is &#x60;DEPROVISIONED&#x60; when the deactivation process is complete. &gt;
     * **Important:** Deactivating a User is a **destructive** operation. The User is deprovisioned from all assigned
     * apps, which might destroy their data such as email or files. **This action cannot be recovered!** You can also
     * perform user deactivation asynchronously. To invoke asynchronous user deactivation, pass an HTTP header
     * &#x60;Prefer: respond-async&#x60; with the request.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param sendEmail
     *            Sends a deactivation email to the admin if &#x60;true&#x60; (optional, default to false)
     * @param prefer
     *            Request asynchronous processing (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateUser(String userId, Boolean sendEmail, String prefer, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deactivateUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/lifecycle/deactivate".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("sendEmail", sendEmail));
        if (prefer != null)
            localVarHeaderParams.put("Prefer", apiClient.parameterToString(prefer));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Reactivate a User Reactivates a user. This operation can only be performed on Users with a
     * &#x60;PROVISIONED&#x60; or &#x60;RECOVERY&#x60;
     * [status](/openapi/okta-management/management/tag/User/#tag/User/operation/listUsers!c&#x3D;200&amp;path&#x3D;status&amp;t&#x3D;response).
     * This operation restarts the activation workflow if for some reason the user activation wasn&#39;t completed when
     * using the &#x60;activationToken&#x60; from [Activate
     * User](/openapi/okta-management/management/tag/UserLifecycle/#tag/UserLifecycle/operation/activateUser). Users
     * that don&#39;t have a password must complete the flow by completing [Reset
     * Password](/openapi/okta-management/management/tag/UserCred/#tag/UserCred/operation/resetPassword) and MFA
     * enrollment steps to transition the user to &#x60;ACTIVE&#x60; status. If &#x60;sendEmail&#x60; is
     * &#x60;false&#x60;, returns an activation link for the user to set up their account. The activation token can be
     * used to create a custom activation link.
     *
     * @param id
     *            &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; (as long as it is unambiguous) of
     *            user (required)
     * @param sendEmail
     *            Sends an activation email to the user if &#x60;true&#x60; (optional, default to false)
     *
     * @return UserActivationToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserActivationToken reactivateUser(String id, Boolean sendEmail) throws ApiException {
        return this.reactivateUser(id, sendEmail, Collections.emptyMap());
    }

    /**
     * Reactivate a User Reactivates a user. This operation can only be performed on Users with a
     * &#x60;PROVISIONED&#x60; or &#x60;RECOVERY&#x60;
     * [status](/openapi/okta-management/management/tag/User/#tag/User/operation/listUsers!c&#x3D;200&amp;path&#x3D;status&amp;t&#x3D;response).
     * This operation restarts the activation workflow if for some reason the user activation wasn&#39;t completed when
     * using the &#x60;activationToken&#x60; from [Activate
     * User](/openapi/okta-management/management/tag/UserLifecycle/#tag/UserLifecycle/operation/activateUser). Users
     * that don&#39;t have a password must complete the flow by completing [Reset
     * Password](/openapi/okta-management/management/tag/UserCred/#tag/UserCred/operation/resetPassword) and MFA
     * enrollment steps to transition the user to &#x60;ACTIVE&#x60; status. If &#x60;sendEmail&#x60; is
     * &#x60;false&#x60;, returns an activation link for the user to set up their account. The activation token can be
     * used to create a custom activation link.
     *
     * @param id
     *            &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; (as long as it is unambiguous) of
     *            user (required)
     * @param sendEmail
     *            Sends an activation email to the user if &#x60;true&#x60; (optional, default to false)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserActivationToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserActivationToken reactivateUser(String id, Boolean sendEmail, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling reactivateUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{id}/lifecycle/reactivate".replaceAll("\\{" + "id" + "\\}",
                apiClient.escapeString(id.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("sendEmail", sendEmail));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserActivationToken> localVarReturnType = new TypeReference<UserActivationToken>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Reset Factors Resets all factors for the specified User. All MFA factor enrollments return to the unenrolled
     * state. The User&#39;s status remains &#x60;ACTIVE&#x60;. This link is present only if the User is currently
     * enrolled in one or more MFA factors.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void resetFactors(String userId) throws ApiException {
        this.resetFactors(userId, Collections.emptyMap());
    }

    /**
     * Reset Factors Resets all factors for the specified User. All MFA factor enrollments return to the unenrolled
     * state. The User&#39;s status remains &#x60;ACTIVE&#x60;. This link is present only if the User is currently
     * enrolled in one or more MFA factors.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void resetFactors(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling resetFactors");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/lifecycle/reset_factors".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Suspend a User Suspends a user. This operation can only be performed on Users with an &#x60;ACTIVE&#x60; status.
     * The User has a &#x60;SUSPENDED&#x60; status when the process completes. Suspended users can&#39;t sign in to
     * Okta. They can only be unsuspended or deactivated. Their group and app assignments are retained.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void suspendUser(String userId) throws ApiException {
        this.suspendUser(userId, Collections.emptyMap());
    }

    /**
     * Suspend a User Suspends a user. This operation can only be performed on Users with an &#x60;ACTIVE&#x60; status.
     * The User has a &#x60;SUSPENDED&#x60; status when the process completes. Suspended users can&#39;t sign in to
     * Okta. They can only be unsuspended or deactivated. Their group and app assignments are retained.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void suspendUser(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling suspendUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/lifecycle/suspend".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Unlock a User Unlocks a User with a &#x60;LOCKED_OUT&#x60; status or unlocks a User with an &#x60;ACTIVE&#x60;
     * status that is blocked from unknown devices. Unlocked Users have an &#x60;ACTIVE&#x60; status and can sign in
     * with their current password. &gt; **Note:** This operation works with Okta-sourced users. It doesn&#39;t support
     * directory-sourced accounts such as Active Directory.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unlockUser(String userId) throws ApiException {
        this.unlockUser(userId, Collections.emptyMap());
    }

    /**
     * Unlock a User Unlocks a User with a &#x60;LOCKED_OUT&#x60; status or unlocks a User with an &#x60;ACTIVE&#x60;
     * status that is blocked from unknown devices. Unlocked Users have an &#x60;ACTIVE&#x60; status and can sign in
     * with their current password. &gt; **Note:** This operation works with Okta-sourced users. It doesn&#39;t support
     * directory-sourced accounts such as Active Directory.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unlockUser(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unlockUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/lifecycle/unlock".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Unsuspend a User Unsuspends a user and returns them to the &#x60;ACTIVE&#x60; state. This operation can only be
     * performed on users that have a &#x60;SUSPENDED&#x60; status.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unsuspendUser(String userId) throws ApiException {
        this.unsuspendUser(userId, Collections.emptyMap());
    }

    /**
     * Unsuspend a User Unsuspends a user and returns them to the &#x60;ACTIVE&#x60; state. This operation can only be
     * performed on users that have a &#x60;SUSPENDED&#x60; status.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unsuspendUser(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unsuspendUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/lifecycle/unsuspend".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
