/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.ResourceSet;
import com.okta.sdk.resource.model.ResourceSetResourcePatchRequest;
import com.okta.sdk.resource.model.ResourceSetResources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class RoleCResourceSetResourceApi {

    private ApiClient apiClient;

    public RoleCResourceSetResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleCResourceSetResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add more Resources to a Resource Set Adds more Resources to a Resource Set
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param instance
     *            (required)
     *
     * @return ResourceSet
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSet addResourceSetResources(String resourceSetIdOrLabel, ResourceSetResourcePatchRequest instance)
            throws ApiException {
        return this.addResourceSetResources(resourceSetIdOrLabel, instance, Collections.emptyMap());
    }

    /**
     * Add more Resources to a Resource Set Adds more Resources to a Resource Set
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ResourceSet
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSet addResourceSetResources(String resourceSetIdOrLabel, ResourceSetResourcePatchRequest instance,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'resourceSetIdOrLabel' is set
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceSetIdOrLabel' when calling addResourceSetResources");
        }

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'instance' when calling addResourceSetResources");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/resources".replaceAll(
                "\\{" + "resourceSetIdOrLabel" + "\\}", apiClient.escapeString(resourceSetIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ResourceSet> localVarReturnType = new TypeReference<ResourceSet>() {
        };
        return apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Resource Set Resource Deletes a Resource (identified by &#x60;resourceId&#x60;) from a Resource Set
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param resourceId
     *            &#x60;id&#x60; of the Resource (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteResourceSetResource(String resourceSetIdOrLabel, String resourceId) throws ApiException {
        this.deleteResourceSetResource(resourceSetIdOrLabel, resourceId, Collections.emptyMap());
    }

    /**
     * Delete a Resource Set Resource Deletes a Resource (identified by &#x60;resourceId&#x60;) from a Resource Set
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param resourceId
     *            &#x60;id&#x60; of the Resource (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteResourceSetResource(String resourceSetIdOrLabel, String resourceId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'resourceSetIdOrLabel' is set
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceSetIdOrLabel' when calling deleteResourceSetResource");
        }

        // verify the required parameter 'resourceId' is set
        if (resourceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceId' when calling deleteResourceSetResource");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/resources/{resourceId}"
                .replaceAll("\\{" + "resourceSetIdOrLabel" + "\\}",
                        apiClient.escapeString(resourceSetIdOrLabel.toString()))
                .replaceAll("\\{" + "resourceId" + "\\}", apiClient.escapeString(resourceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * List all Resource Set Resources Lists all Resources for the Resource Set
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     *
     * @return ResourceSetResources
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSetResources listResourceSetResources(String resourceSetIdOrLabel) throws ApiException {
        return this.listResourceSetResources(resourceSetIdOrLabel, Collections.emptyMap());
    }

    /**
     * List all Resource Set Resources Lists all Resources for the Resource Set
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ResourceSetResources
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSetResources listResourceSetResources(String resourceSetIdOrLabel,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'resourceSetIdOrLabel' is set
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceSetIdOrLabel' when calling listResourceSetResources");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/resources".replaceAll(
                "\\{" + "resourceSetIdOrLabel" + "\\}", apiClient.escapeString(resourceSetIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ResourceSetResources> localVarReturnType = new TypeReference<ResourceSetResources>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
