/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.AssignRoleToGroupRequest;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.ListGroupAssignedRoles200ResponseInner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class RoleAssignmentBGroupApi {

    private ApiClient apiClient;

    public RoleAssignmentBGroupApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleAssignmentBGroupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Assign a Role to a Group Assigns a [standard role](/openapi/okta-management/guides/roles/#standard-roles) to a
     * Group. You can also assign a custom role to a Group, but the preferred method to assign a custom role to a Group
     * is to create a binding between the Custom Role, the Resource Set, and the Group. See [Create a Role Resource Set
     * Binding](/openapi/okta-management/management/tag/RoleDResourceSetBinding/#tag/RoleDResourceSetBinding/operation/createResourceSetBinding).
     * &gt; **Notes:** &gt; * The request payload is different for standard and custom role assignments. &gt; * For
     * IAM-based standard role assignments, use the request payload for standard roles. However, the response payload
     * for IAM-based role assignments is similar to the custom role&#39;s assignment response.
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param assignRoleRequest
     *            (required)
     * @param disableNotifications
     *            Grants the Group third-party admin status when set to &#x60;true&#x60; (optional, default to false)
     *
     * @return ListGroupAssignedRoles200ResponseInner
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ListGroupAssignedRoles200ResponseInner assignRoleToGroup(String groupId,
            AssignRoleToGroupRequest assignRoleRequest, Boolean disableNotifications) throws ApiException {
        return this.assignRoleToGroup(groupId, assignRoleRequest, disableNotifications, Collections.emptyMap());
    }

    /**
     * Assign a Role to a Group Assigns a [standard role](/openapi/okta-management/guides/roles/#standard-roles) to a
     * Group. You can also assign a custom role to a Group, but the preferred method to assign a custom role to a Group
     * is to create a binding between the Custom Role, the Resource Set, and the Group. See [Create a Role Resource Set
     * Binding](/openapi/okta-management/management/tag/RoleDResourceSetBinding/#tag/RoleDResourceSetBinding/operation/createResourceSetBinding).
     * &gt; **Notes:** &gt; * The request payload is different for standard and custom role assignments. &gt; * For
     * IAM-based standard role assignments, use the request payload for standard roles. However, the response payload
     * for IAM-based role assignments is similar to the custom role&#39;s assignment response.
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param assignRoleRequest
     *            (required)
     * @param disableNotifications
     *            Grants the Group third-party admin status when set to &#x60;true&#x60; (optional, default to false)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ListGroupAssignedRoles200ResponseInner
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ListGroupAssignedRoles200ResponseInner assignRoleToGroup(String groupId,
            AssignRoleToGroupRequest assignRoleRequest, Boolean disableNotifications,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = assignRoleRequest;

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignRoleToGroup");
        }

        // verify the required parameter 'assignRoleRequest' is set
        if (assignRoleRequest == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'assignRoleRequest' when calling assignRoleToGroup");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/{groupId}/roles".replaceAll("\\{" + "groupId" + "\\}",
                apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("disableNotifications", disableNotifications));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ListGroupAssignedRoles200ResponseInner> localVarReturnType = new TypeReference<ListGroupAssignedRoles200ResponseInner>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a Group Role Assignment Retrieves a Role assigned to a Group (identified by the &#x60;groupId&#x60;).
     * The &#x60;roleAssignmentId&#x60; is the unique identifier for either a standard role Group Assignment object or a
     * custom role Resource Set Binding object.
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     *
     * @return ListGroupAssignedRoles200ResponseInner
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ListGroupAssignedRoles200ResponseInner getGroupAssignedRole(String groupId, String roleAssignmentId)
            throws ApiException {
        return this.getGroupAssignedRole(groupId, roleAssignmentId, Collections.emptyMap());
    }

    /**
     * Retrieve a Group Role Assignment Retrieves a Role assigned to a Group (identified by the &#x60;groupId&#x60;).
     * The &#x60;roleAssignmentId&#x60; is the unique identifier for either a standard role Group Assignment object or a
     * custom role Resource Set Binding object.
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ListGroupAssignedRoles200ResponseInner
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ListGroupAssignedRoles200ResponseInner getGroupAssignedRole(String groupId, String roleAssignmentId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getGroupAssignedRole");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling getGroupAssignedRole");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleAssignmentId}"
                .replaceAll("\\{" + "groupId" + "\\}", apiClient.escapeString(groupId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ListGroupAssignedRoles200ResponseInner> localVarReturnType = new TypeReference<ListGroupAssignedRoles200ResponseInner>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Group Role Assignments Lists all assigned roles of a Group by &#x60;groupId&#x60;
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param expand
     *            An optional parameter used to return targets configured for the standard Role Assignment in the
     *            &#x60;embedded&#x60; property. Supported values: &#x60;targets/groups&#x60; or
     *            &#x60;targets/catalog/apps&#x60; (optional)
     *
     * @return List&lt;ListGroupAssignedRoles200ResponseInner&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ListGroupAssignedRoles200ResponseInner> listGroupAssignedRoles(String groupId, String expand)
            throws ApiException {
        return this.listGroupAssignedRoles(groupId, expand, Collections.emptyMap());
    }

    /**
     * List all Group Role Assignments Lists all assigned roles of a Group by &#x60;groupId&#x60;
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param expand
     *            An optional parameter used to return targets configured for the standard Role Assignment in the
     *            &#x60;embedded&#x60; property. Supported values: &#x60;targets/groups&#x60; or
     *            &#x60;targets/catalog/apps&#x60; (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;ListGroupAssignedRoles200ResponseInner&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ListGroupAssignedRoles200ResponseInner> listGroupAssignedRoles(String groupId, String expand,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling listGroupAssignedRoles");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/{groupId}/roles".replaceAll("\\{" + "groupId" + "\\}",
                apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<ListGroupAssignedRoles200ResponseInner>> localVarReturnType = new TypeReference<List<ListGroupAssignedRoles200ResponseInner>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Unassign a Group Role Unassigns a Role Assignment (identified by &#x60;roleAssignmentId&#x60;) from a Group
     * (identified by the &#x60;groupId&#x60;)
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignRoleFromGroup(String groupId, String roleAssignmentId) throws ApiException {
        this.unassignRoleFromGroup(groupId, roleAssignmentId, Collections.emptyMap());
    }

    /**
     * Unassign a Group Role Unassigns a Role Assignment (identified by &#x60;roleAssignmentId&#x60;) from a Group
     * (identified by the &#x60;groupId&#x60;)
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignRoleFromGroup(String groupId, String roleAssignmentId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling unassignRoleFromGroup");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling unassignRoleFromGroup");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleAssignmentId}"
                .replaceAll("\\{" + "groupId" + "\\}", apiClient.escapeString(groupId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
