/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.DetailedHookKeyInstance;
import com.okta.sdk.resource.model.Embedded;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.HookKey;
import com.okta.sdk.resource.model.KeyRequest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class HookKeyApi {

    private ApiClient apiClient;

    public HookKeyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HookKeyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a key Creates a key for use with other parts of the application, such as inline hooks &gt; **Note:** Use
     * the key name to access this key for inline hook operations. The total number of keys that you can create in an
     * Okta org is limited to 50.
     *
     * @param keyRequest
     *            (required)
     *
     * @return DetailedHookKeyInstance
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DetailedHookKeyInstance createHookKey(KeyRequest keyRequest) throws ApiException {
        return this.createHookKey(keyRequest, Collections.emptyMap());
    }

    /**
     * Create a key Creates a key for use with other parts of the application, such as inline hooks &gt; **Note:** Use
     * the key name to access this key for inline hook operations. The total number of keys that you can create in an
     * Okta org is limited to 50.
     *
     * @param keyRequest
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return DetailedHookKeyInstance
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DetailedHookKeyInstance createHookKey(KeyRequest keyRequest, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = keyRequest;

        // verify the required parameter 'keyRequest' is set
        if (keyRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'keyRequest' when calling createHookKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/hook-keys";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<DetailedHookKeyInstance> localVarReturnType = new TypeReference<DetailedHookKeyInstance>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a key Deletes a key by &#x60;id&#x60;. After being deleted, the key is unrecoverable. As a safety
     * precaution, only keys that aren&#39;t being used are eligible for deletion.
     *
     * @param id
     *            ID of the Hook Key (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteHookKey(String id) throws ApiException {
        this.deleteHookKey(id, Collections.emptyMap());
    }

    /**
     * Delete a key Deletes a key by &#x60;id&#x60;. After being deleted, the key is unrecoverable. As a safety
     * precaution, only keys that aren&#39;t being used are eligible for deletion.
     *
     * @param id
     *            ID of the Hook Key (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteHookKey(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteHookKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/hook-keys/{id}".replaceAll("\\{" + "id" + "\\}",
                apiClient.escapeString(id.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a key by ID Retrieves the public portion of the Key object using the &#x60;id&#x60; parameter
     * &gt;**Note:** The &#x60;?expand&#x3D;publickey&#x60; query parameter optionally returns the full object including
     * the details of the public key in the response body&#39;s &#x60;_embedded&#x60; property.
     *
     * @param id
     *            ID of the Hook Key (required)
     *
     * @return HookKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public HookKey getHookKey(String id) throws ApiException {
        return this.getHookKey(id, Collections.emptyMap());
    }

    /**
     * Retrieve a key by ID Retrieves the public portion of the Key object using the &#x60;id&#x60; parameter
     * &gt;**Note:** The &#x60;?expand&#x3D;publickey&#x60; query parameter optionally returns the full object including
     * the details of the public key in the response body&#39;s &#x60;_embedded&#x60; property.
     *
     * @param id
     *            ID of the Hook Key (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return HookKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public HookKey getHookKey(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getHookKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/hook-keys/{id}".replaceAll("\\{" + "id" + "\\}",
                apiClient.escapeString(id.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<HookKey> localVarReturnType = new TypeReference<HookKey>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a public key Retrieves a public key by &#x60;keyId&#x60; &gt;**Note:** keyId is the alias of the public
     * key.
     *
     * @param keyId
     *            id\&quot; of the Public Key (required)
     *
     * @return Embedded
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Embedded getPublicKey(String keyId) throws ApiException {
        return this.getPublicKey(keyId, Collections.emptyMap());
    }

    /**
     * Retrieve a public key Retrieves a public key by &#x60;keyId&#x60; &gt;**Note:** keyId is the alias of the public
     * key.
     *
     * @param keyId
     *            id\&quot; of the Public Key (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Embedded
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Embedded getPublicKey(String keyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'keyId' is set
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling getPublicKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/hook-keys/public/{keyId}".replaceAll("\\{" + "keyId" + "\\}",
                apiClient.escapeString(keyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Embedded> localVarReturnType = new TypeReference<Embedded>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all keys Lists all keys
     *
     * @return List&lt;HookKey&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<HookKey> listHookKeys() throws ApiException {
        return this.listHookKeys(Collections.emptyMap());
    }

    /**
     * List all keys Lists all keys
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;HookKey&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<HookKey> listHookKeys(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/hook-keys";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<HookKey>> localVarReturnType = new TypeReference<List<HookKey>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a key Replaces a key by &#x60;id&#x60; This request replaces existing properties after passing
     * validation. &gt; **Note:** The only parameter that you can update is the name of the key, which must be unique at
     * all times.
     *
     * @param id
     *            ID of the Hook Key (required)
     * @param keyRequest
     *            (required)
     *
     * @return DetailedHookKeyInstance
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DetailedHookKeyInstance replaceHookKey(String id, KeyRequest keyRequest) throws ApiException {
        return this.replaceHookKey(id, keyRequest, Collections.emptyMap());
    }

    /**
     * Replace a key Replaces a key by &#x60;id&#x60; This request replaces existing properties after passing
     * validation. &gt; **Note:** The only parameter that you can update is the name of the key, which must be unique at
     * all times.
     *
     * @param id
     *            ID of the Hook Key (required)
     * @param keyRequest
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return DetailedHookKeyInstance
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DetailedHookKeyInstance replaceHookKey(String id, KeyRequest keyRequest,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = keyRequest;

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling replaceHookKey");
        }

        // verify the required parameter 'keyRequest' is set
        if (keyRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'keyRequest' when calling replaceHookKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/hook-keys/{id}".replaceAll("\\{" + "id" + "\\}",
                apiClient.escapeString(id.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<DetailedHookKeyInstance> localVarReturnType = new TypeReference<DetailedHookKeyInstance>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
