/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.AuthorizationServerPolicyRule;
import com.okta.sdk.resource.model.AuthorizationServerPolicyRuleRequest;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AuthorizationServerRulesApi {

    private ApiClient apiClient;

    public AuthorizationServerRulesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationServerRulesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate a Policy Rule Activates an authorization server policy rule
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param ruleId
     *            &#x60;id&#x60; of the Policy Rule (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId)
            throws ApiException {
        this.activateAuthorizationServerPolicyRule(authServerId, policyId, ruleId, Collections.emptyMap());
    }

    /**
     * Activate a Policy Rule Activates an authorization server policy rule
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param ruleId
     *            &#x60;id&#x60; of the Policy Rule (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling activateAuthorizationServerPolicyRule");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyId' when calling activateAuthorizationServerPolicyRule");
        }

        // verify the required parameter 'ruleId' is set
        if (ruleId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'ruleId' when calling activateAuthorizationServerPolicyRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/activate"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "policyId" + "\\}", apiClient.escapeString(policyId.toString()))
                .replaceAll("\\{" + "ruleId" + "\\}", apiClient.escapeString(ruleId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Create a Policy Rule Creates a policy rule for the specified Custom Authorization Server and Policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param policyRule
     *            (required)
     *
     * @return AuthorizationServerPolicyRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServerPolicyRule createAuthorizationServerPolicyRule(String authServerId, String policyId,
            AuthorizationServerPolicyRuleRequest policyRule) throws ApiException {
        return this.createAuthorizationServerPolicyRule(authServerId, policyId, policyRule, Collections.emptyMap());
    }

    /**
     * Create a Policy Rule Creates a policy rule for the specified Custom Authorization Server and Policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param policyRule
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthorizationServerPolicyRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServerPolicyRule createAuthorizationServerPolicyRule(String authServerId, String policyId,
            AuthorizationServerPolicyRuleRequest policyRule, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = policyRule;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicyRule");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyId' when calling createAuthorizationServerPolicyRule");
        }

        // verify the required parameter 'policyRule' is set
        if (policyRule == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyRule' when calling createAuthorizationServerPolicyRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "policyId" + "\\}", apiClient.escapeString(policyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthorizationServerPolicyRule> localVarReturnType = new TypeReference<AuthorizationServerPolicyRule>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate a Policy Rule Deactivates an authorization server policy rule
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param ruleId
     *            &#x60;id&#x60; of the Policy Rule (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId)
            throws ApiException {
        this.deactivateAuthorizationServerPolicyRule(authServerId, policyId, ruleId, Collections.emptyMap());
    }

    /**
     * Deactivate a Policy Rule Deactivates an authorization server policy rule
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param ruleId
     *            &#x60;id&#x60; of the Policy Rule (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling deactivateAuthorizationServerPolicyRule");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyId' when calling deactivateAuthorizationServerPolicyRule");
        }

        // verify the required parameter 'ruleId' is set
        if (ruleId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'ruleId' when calling deactivateAuthorizationServerPolicyRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/deactivate"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "policyId" + "\\}", apiClient.escapeString(policyId.toString()))
                .replaceAll("\\{" + "ruleId" + "\\}", apiClient.escapeString(ruleId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Delete a Policy Rule Deletes a Policy Rule defined in the specified Custom Authorization Server and Policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param ruleId
     *            &#x60;id&#x60; of the Policy Rule (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId)
            throws ApiException {
        this.deleteAuthorizationServerPolicyRule(authServerId, policyId, ruleId, Collections.emptyMap());
    }

    /**
     * Delete a Policy Rule Deletes a Policy Rule defined in the specified Custom Authorization Server and Policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param ruleId
     *            &#x60;id&#x60; of the Policy Rule (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling deleteAuthorizationServerPolicyRule");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyId' when calling deleteAuthorizationServerPolicyRule");
        }

        // verify the required parameter 'ruleId' is set
        if (ruleId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'ruleId' when calling deleteAuthorizationServerPolicyRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "policyId" + "\\}", apiClient.escapeString(policyId.toString()))
                .replaceAll("\\{" + "ruleId" + "\\}", apiClient.escapeString(ruleId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Policy Rule Retrieves a policy rule by &#x60;ruleId&#x60;
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param ruleId
     *            &#x60;id&#x60; of the Policy Rule (required)
     *
     * @return AuthorizationServerPolicyRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServerPolicyRule getAuthorizationServerPolicyRule(String authServerId, String policyId,
            String ruleId) throws ApiException {
        return this.getAuthorizationServerPolicyRule(authServerId, policyId, ruleId, Collections.emptyMap());
    }

    /**
     * Retrieve a Policy Rule Retrieves a policy rule by &#x60;ruleId&#x60;
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param ruleId
     *            &#x60;id&#x60; of the Policy Rule (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthorizationServerPolicyRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServerPolicyRule getAuthorizationServerPolicyRule(String authServerId, String policyId,
            String ruleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling getAuthorizationServerPolicyRule");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyId' when calling getAuthorizationServerPolicyRule");
        }

        // verify the required parameter 'ruleId' is set
        if (ruleId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'ruleId' when calling getAuthorizationServerPolicyRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "policyId" + "\\}", apiClient.escapeString(policyId.toString()))
                .replaceAll("\\{" + "ruleId" + "\\}", apiClient.escapeString(ruleId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthorizationServerPolicyRule> localVarReturnType = new TypeReference<AuthorizationServerPolicyRule>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Policy Rules Lists all policy rules for the specified Custom Authorization Server and Policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     *
     * @return List&lt;AuthorizationServerPolicyRule&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthorizationServerPolicyRule> listAuthorizationServerPolicyRules(String authServerId, String policyId)
            throws ApiException {
        return this.listAuthorizationServerPolicyRules(authServerId, policyId, Collections.emptyMap());
    }

    /**
     * List all Policy Rules Lists all policy rules for the specified Custom Authorization Server and Policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;AuthorizationServerPolicyRule&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthorizationServerPolicyRule> listAuthorizationServerPolicyRules(String authServerId, String policyId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling listAuthorizationServerPolicyRules");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyId' when calling listAuthorizationServerPolicyRules");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "policyId" + "\\}", apiClient.escapeString(policyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<AuthorizationServerPolicyRule>> localVarReturnType = new TypeReference<List<AuthorizationServerPolicyRule>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Policy Rule Replaces the configuration of the Policy Rule defined in the specified Custom Authorization
     * Server and Policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param ruleId
     *            &#x60;id&#x60; of the Policy Rule (required)
     * @param policyRule
     *            (required)
     *
     * @return AuthorizationServerPolicyRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServerPolicyRule replaceAuthorizationServerPolicyRule(String authServerId, String policyId,
            String ruleId, AuthorizationServerPolicyRuleRequest policyRule) throws ApiException {
        return this.replaceAuthorizationServerPolicyRule(authServerId, policyId, ruleId, policyRule,
                Collections.emptyMap());
    }

    /**
     * Replace a Policy Rule Replaces the configuration of the Policy Rule defined in the specified Custom Authorization
     * Server and Policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param ruleId
     *            &#x60;id&#x60; of the Policy Rule (required)
     * @param policyRule
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthorizationServerPolicyRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServerPolicyRule replaceAuthorizationServerPolicyRule(String authServerId, String policyId,
            String ruleId, AuthorizationServerPolicyRuleRequest policyRule, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = policyRule;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicyRule");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicyRule");
        }

        // verify the required parameter 'ruleId' is set
        if (ruleId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'ruleId' when calling replaceAuthorizationServerPolicyRule");
        }

        // verify the required parameter 'policyRule' is set
        if (policyRule == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyRule' when calling replaceAuthorizationServerPolicyRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "policyId" + "\\}", apiClient.escapeString(policyId.toString()))
                .replaceAll("\\{" + "ruleId" + "\\}", apiClient.escapeString(ruleId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthorizationServerPolicyRule> localVarReturnType = new TypeReference<AuthorizationServerPolicyRule>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
