/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.AuthenticatorBase;
import com.okta.sdk.resource.model.AuthenticatorMethodBase;
import com.okta.sdk.resource.model.AuthenticatorMethodType;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.WellKnownAppAuthenticatorConfiguration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AuthenticatorApi {

    private ApiClient apiClient;

    public AuthenticatorApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthenticatorApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate an Authenticator Activates an authenticator by &#x60;authenticatorId&#x60;
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     *
     * @return AuthenticatorBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorBase activateAuthenticator(String authenticatorId) throws ApiException {
        return this.activateAuthenticator(authenticatorId, Collections.emptyMap());
    }

    /**
     * Activate an Authenticator Activates an authenticator by &#x60;authenticatorId&#x60;
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthenticatorBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorBase activateAuthenticator(String authenticatorId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authenticatorId' is set
        if (authenticatorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authenticatorId' when calling activateAuthenticator");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/lifecycle/activate"
                .replaceAll("\\{" + "authenticatorId" + "\\}", apiClient.escapeString(authenticatorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthenticatorBase> localVarReturnType = new TypeReference<AuthenticatorBase>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Activate an Authenticator Method Activates a Method for an Authenticator identified by
     * &#x60;authenticatorId&#x60; and &#x60;methodType&#x60; &gt; **Note:** &lt;x-lifecycle
     * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; &gt; The AAGUID Group object supports the Early Access
     * (Self-Service) Allow List for FIDO2 (WebAuthn) Authenticators feature. Enable the feature for your org from the
     * **Settings** &gt; **Features** page in the Admin Console. &gt; This feature has several limitations when
     * enrolling a security key: &gt; - Enrollment is currently unsupported on Firefox. &gt; - Enrollment is currently
     * unsupported on Chrome if User Verification is set to DISCOURAGED and a PIN is set on the security key. &gt; - If
     * prompted during enrollment, users must allow Okta to see the make and model of the security key.
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     * @param methodType
     *            Type of authenticator method (required)
     *
     * @return AuthenticatorMethodBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorMethodBase activateAuthenticatorMethod(String authenticatorId,
            AuthenticatorMethodType methodType) throws ApiException {
        return this.activateAuthenticatorMethod(authenticatorId, methodType, Collections.emptyMap());
    }

    /**
     * Activate an Authenticator Method Activates a Method for an Authenticator identified by
     * &#x60;authenticatorId&#x60; and &#x60;methodType&#x60; &gt; **Note:** &lt;x-lifecycle
     * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; &gt; The AAGUID Group object supports the Early Access
     * (Self-Service) Allow List for FIDO2 (WebAuthn) Authenticators feature. Enable the feature for your org from the
     * **Settings** &gt; **Features** page in the Admin Console. &gt; This feature has several limitations when
     * enrolling a security key: &gt; - Enrollment is currently unsupported on Firefox. &gt; - Enrollment is currently
     * unsupported on Chrome if User Verification is set to DISCOURAGED and a PIN is set on the security key. &gt; - If
     * prompted during enrollment, users must allow Okta to see the make and model of the security key.
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     * @param methodType
     *            Type of authenticator method (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthenticatorMethodBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorMethodBase activateAuthenticatorMethod(String authenticatorId,
            AuthenticatorMethodType methodType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authenticatorId' is set
        if (authenticatorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authenticatorId' when calling activateAuthenticatorMethod");
        }

        // verify the required parameter 'methodType' is set
        if (methodType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'methodType' when calling activateAuthenticatorMethod");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods/{methodType}/lifecycle/activate"
                .replaceAll("\\{" + "authenticatorId" + "\\}", apiClient.escapeString(authenticatorId.toString()))
                .replaceAll("\\{" + "methodType" + "\\}", apiClient.escapeString(methodType.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthenticatorMethodBase> localVarReturnType = new TypeReference<AuthenticatorMethodBase>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create an Authenticator Creates an authenticator
     *
     * @param authenticator
     *            (required)
     * @param activate
     *            Whether to execute the activation lifecycle operation when Okta creates the authenticator (optional,
     *            default to true)
     *
     * @return AuthenticatorBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorBase createAuthenticator(AuthenticatorBase authenticator, Boolean activate)
            throws ApiException {
        return this.createAuthenticator(authenticator, activate, Collections.emptyMap());
    }

    /**
     * Create an Authenticator Creates an authenticator
     *
     * @param authenticator
     *            (required)
     * @param activate
     *            Whether to execute the activation lifecycle operation when Okta creates the authenticator (optional,
     *            default to true)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthenticatorBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorBase createAuthenticator(AuthenticatorBase authenticator, Boolean activate,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = authenticator;

        // verify the required parameter 'authenticator' is set
        if (authenticator == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authenticator' when calling createAuthenticator");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authenticators";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("activate", activate));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthenticatorBase> localVarReturnType = new TypeReference<AuthenticatorBase>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate an Authenticator Deactivates an authenticator by &#x60;authenticatorId&#x60;
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     *
     * @return AuthenticatorBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorBase deactivateAuthenticator(String authenticatorId) throws ApiException {
        return this.deactivateAuthenticator(authenticatorId, Collections.emptyMap());
    }

    /**
     * Deactivate an Authenticator Deactivates an authenticator by &#x60;authenticatorId&#x60;
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthenticatorBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorBase deactivateAuthenticator(String authenticatorId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authenticatorId' is set
        if (authenticatorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authenticatorId' when calling deactivateAuthenticator");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/lifecycle/deactivate"
                .replaceAll("\\{" + "authenticatorId" + "\\}", apiClient.escapeString(authenticatorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthenticatorBase> localVarReturnType = new TypeReference<AuthenticatorBase>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate an Authenticator Method Deactivates a Method for an Authenticator identified by
     * &#x60;authenticatorId&#x60; and &#x60;methodType&#x60; &gt; **Note:** &lt;x-lifecycle
     * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; &gt; The AAGUID Group object supports the Early Access
     * (Self-Service) Allow List for FIDO2 (WebAuthn) Authenticators feature. Enable the feature for your org from the
     * **Settings** &gt; **Features** page in the Admin Console. &gt; This feature has several limitations when
     * enrolling a security key: &gt; - Enrollment is currently unsupported on Firefox. &gt; - Enrollment is currently
     * unsupported on Chrome if User Verification is set to DISCOURAGED and a PIN is set on the security key. &gt; - If
     * prompted during enrollment, users must allow Okta to see the make and model of the security key.
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     * @param methodType
     *            Type of authenticator method (required)
     *
     * @return AuthenticatorMethodBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorMethodBase deactivateAuthenticatorMethod(String authenticatorId,
            AuthenticatorMethodType methodType) throws ApiException {
        return this.deactivateAuthenticatorMethod(authenticatorId, methodType, Collections.emptyMap());
    }

    /**
     * Deactivate an Authenticator Method Deactivates a Method for an Authenticator identified by
     * &#x60;authenticatorId&#x60; and &#x60;methodType&#x60; &gt; **Note:** &lt;x-lifecycle
     * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; &gt; The AAGUID Group object supports the Early Access
     * (Self-Service) Allow List for FIDO2 (WebAuthn) Authenticators feature. Enable the feature for your org from the
     * **Settings** &gt; **Features** page in the Admin Console. &gt; This feature has several limitations when
     * enrolling a security key: &gt; - Enrollment is currently unsupported on Firefox. &gt; - Enrollment is currently
     * unsupported on Chrome if User Verification is set to DISCOURAGED and a PIN is set on the security key. &gt; - If
     * prompted during enrollment, users must allow Okta to see the make and model of the security key.
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     * @param methodType
     *            Type of authenticator method (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthenticatorMethodBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorMethodBase deactivateAuthenticatorMethod(String authenticatorId,
            AuthenticatorMethodType methodType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authenticatorId' is set
        if (authenticatorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authenticatorId' when calling deactivateAuthenticatorMethod");
        }

        // verify the required parameter 'methodType' is set
        if (methodType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'methodType' when calling deactivateAuthenticatorMethod");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods/{methodType}/lifecycle/deactivate"
                .replaceAll("\\{" + "authenticatorId" + "\\}", apiClient.escapeString(authenticatorId.toString()))
                .replaceAll("\\{" + "methodType" + "\\}", apiClient.escapeString(methodType.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthenticatorMethodBase> localVarReturnType = new TypeReference<AuthenticatorMethodBase>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve an Authenticator Retrieves an authenticator from your Okta organization by &#x60;authenticatorId&#x60;
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     *
     * @return AuthenticatorBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorBase getAuthenticator(String authenticatorId) throws ApiException {
        return this.getAuthenticator(authenticatorId, Collections.emptyMap());
    }

    /**
     * Retrieve an Authenticator Retrieves an authenticator from your Okta organization by &#x60;authenticatorId&#x60;
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthenticatorBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorBase getAuthenticator(String authenticatorId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authenticatorId' is set
        if (authenticatorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authenticatorId' when calling getAuthenticator");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authenticators/{authenticatorId}".replaceAll("\\{" + "authenticatorId" + "\\}",
                apiClient.escapeString(authenticatorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthenticatorBase> localVarReturnType = new TypeReference<AuthenticatorBase>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve an Authenticator Method Retrieves a Method identified by &#x60;methodType&#x60; of an Authenticator
     * identified by &#x60;authenticatorId&#x60; &gt; **Note:** &lt;x-lifecycle
     * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; &gt; The AAGUID Group object supports the Early Access
     * (Self-Service) Allow List for FIDO2 (WebAuthn) Authenticators feature. Enable the feature for your org from the
     * **Settings** &gt; **Features** page in the Admin Console. &gt; This feature has several limitations when
     * enrolling a security key: &gt; - Enrollment is currently unsupported on Firefox. &gt; - Enrollment is currently
     * unsupported on Chrome if User Verification is set to DISCOURAGED and a PIN is set on the security key. &gt; - If
     * prompted during enrollment, users must allow Okta to see the make and model of the security key.
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     * @param methodType
     *            Type of authenticator method (required)
     *
     * @return AuthenticatorMethodBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorMethodBase getAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType)
            throws ApiException {
        return this.getAuthenticatorMethod(authenticatorId, methodType, Collections.emptyMap());
    }

    /**
     * Retrieve an Authenticator Method Retrieves a Method identified by &#x60;methodType&#x60; of an Authenticator
     * identified by &#x60;authenticatorId&#x60; &gt; **Note:** &lt;x-lifecycle
     * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; &gt; The AAGUID Group object supports the Early Access
     * (Self-Service) Allow List for FIDO2 (WebAuthn) Authenticators feature. Enable the feature for your org from the
     * **Settings** &gt; **Features** page in the Admin Console. &gt; This feature has several limitations when
     * enrolling a security key: &gt; - Enrollment is currently unsupported on Firefox. &gt; - Enrollment is currently
     * unsupported on Chrome if User Verification is set to DISCOURAGED and a PIN is set on the security key. &gt; - If
     * prompted during enrollment, users must allow Okta to see the make and model of the security key.
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     * @param methodType
     *            Type of authenticator method (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthenticatorMethodBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorMethodBase getAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authenticatorId' is set
        if (authenticatorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authenticatorId' when calling getAuthenticatorMethod");
        }

        // verify the required parameter 'methodType' is set
        if (methodType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'methodType' when calling getAuthenticatorMethod");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods/{methodType}"
                .replaceAll("\\{" + "authenticatorId" + "\\}", apiClient.escapeString(authenticatorId.toString()))
                .replaceAll("\\{" + "methodType" + "\\}", apiClient.escapeString(methodType.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthenticatorMethodBase> localVarReturnType = new TypeReference<AuthenticatorMethodBase>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve the Well-Known App Authenticator Configuration Retrieves the well-known app authenticator configuration.
     * Includes an app authenticator&#39;s settings, supported methods, and other details.
     *
     * @param oauthClientId
     *            Filters app authenticator configurations by &#x60;oauthClientId&#x60; (required)
     *
     * @return List&lt;WellKnownAppAuthenticatorConfiguration&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<WellKnownAppAuthenticatorConfiguration> getWellKnownAppAuthenticatorConfiguration(String oauthClientId)
            throws ApiException {
        return this.getWellKnownAppAuthenticatorConfiguration(oauthClientId, Collections.emptyMap());
    }

    /**
     * Retrieve the Well-Known App Authenticator Configuration Retrieves the well-known app authenticator configuration.
     * Includes an app authenticator&#39;s settings, supported methods, and other details.
     *
     * @param oauthClientId
     *            Filters app authenticator configurations by &#x60;oauthClientId&#x60; (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;WellKnownAppAuthenticatorConfiguration&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<WellKnownAppAuthenticatorConfiguration> getWellKnownAppAuthenticatorConfiguration(String oauthClientId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'oauthClientId' is set
        if (oauthClientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'oauthClientId' when calling getWellKnownAppAuthenticatorConfiguration");
        }

        // create path and map variables
        String localVarPath = "/.well-known/app-authenticator-configuration";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("oauthClientId", oauthClientId));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {};

        TypeReference<List<WellKnownAppAuthenticatorConfiguration>> localVarReturnType = new TypeReference<List<WellKnownAppAuthenticatorConfiguration>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Methods of an Authenticator Lists all Methods of an Authenticator identified by
     * &#x60;authenticatorId&#x60; &gt; **Note:** &lt;x-lifecycle class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt;
     * &gt; The AAGUID Group object supports the Early Access (Self-Service) Allow List for FIDO2 (WebAuthn)
     * Authenticators feature. Enable the feature for your org from the **Settings** &gt; **Features** page in the Admin
     * Console. &gt; This feature has several limitations when enrolling a security key: &gt; - Enrollment is currently
     * unsupported on Firefox. &gt; - Enrollment is currently unsupported on Chrome if User Verification is set to
     * DISCOURAGED and a PIN is set on the security key. &gt; - If prompted during enrollment, users must allow Okta to
     * see the make and model of the security key.
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     *
     * @return List&lt;AuthenticatorMethodBase&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthenticatorMethodBase> listAuthenticatorMethods(String authenticatorId) throws ApiException {
        return this.listAuthenticatorMethods(authenticatorId, Collections.emptyMap());
    }

    /**
     * List all Methods of an Authenticator Lists all Methods of an Authenticator identified by
     * &#x60;authenticatorId&#x60; &gt; **Note:** &lt;x-lifecycle class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt;
     * &gt; The AAGUID Group object supports the Early Access (Self-Service) Allow List for FIDO2 (WebAuthn)
     * Authenticators feature. Enable the feature for your org from the **Settings** &gt; **Features** page in the Admin
     * Console. &gt; This feature has several limitations when enrolling a security key: &gt; - Enrollment is currently
     * unsupported on Firefox. &gt; - Enrollment is currently unsupported on Chrome if User Verification is set to
     * DISCOURAGED and a PIN is set on the security key. &gt; - If prompted during enrollment, users must allow Okta to
     * see the make and model of the security key.
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;AuthenticatorMethodBase&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthenticatorMethodBase> listAuthenticatorMethods(String authenticatorId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authenticatorId' is set
        if (authenticatorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authenticatorId' when calling listAuthenticatorMethods");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods"
                .replaceAll("\\{" + "authenticatorId" + "\\}", apiClient.escapeString(authenticatorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<AuthenticatorMethodBase>> localVarReturnType = new TypeReference<List<AuthenticatorMethodBase>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Authenticators Lists all authenticators
     *
     * @return List&lt;AuthenticatorBase&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthenticatorBase> listAuthenticators() throws ApiException {
        return this.listAuthenticators(Collections.emptyMap());
    }

    /**
     * List all Authenticators Lists all authenticators
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;AuthenticatorBase&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthenticatorBase> listAuthenticators(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/authenticators";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<AuthenticatorBase>> localVarReturnType = new TypeReference<List<AuthenticatorBase>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace an Authenticator Replaces the properties for an Authenticator identified by &#x60;authenticatorId&#x60;
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     * @param authenticator
     *            (required)
     *
     * @return AuthenticatorBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorBase replaceAuthenticator(String authenticatorId, AuthenticatorBase authenticator)
            throws ApiException {
        return this.replaceAuthenticator(authenticatorId, authenticator, Collections.emptyMap());
    }

    /**
     * Replace an Authenticator Replaces the properties for an Authenticator identified by &#x60;authenticatorId&#x60;
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     * @param authenticator
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthenticatorBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorBase replaceAuthenticator(String authenticatorId, AuthenticatorBase authenticator,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = authenticator;

        // verify the required parameter 'authenticatorId' is set
        if (authenticatorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authenticatorId' when calling replaceAuthenticator");
        }

        // verify the required parameter 'authenticator' is set
        if (authenticator == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authenticator' when calling replaceAuthenticator");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authenticators/{authenticatorId}".replaceAll("\\{" + "authenticatorId" + "\\}",
                apiClient.escapeString(authenticatorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthenticatorBase> localVarReturnType = new TypeReference<AuthenticatorBase>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace an Authenticator Method Replaces a Method of &#x60;methodType&#x60; for an Authenticator identified by
     * &#x60;authenticatorId&#x60; &gt; **Note:** &lt;x-lifecycle class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt;
     * &gt; The AAGUID Group object supports the Early Access (Self-Service) Allow List for FIDO2 (WebAuthn)
     * Authenticators feature. Enable the feature for your org from the **Settings** &gt; **Features** page in the Admin
     * Console. &gt; This feature has several limitations when enrolling a security key: &gt; - Enrollment is currently
     * unsupported on Firefox. &gt; - Enrollment is currently unsupported on Chrome if User Verification is set to
     * DISCOURAGED and a PIN is set on the security key. &gt; - If prompted during enrollment, users must allow Okta to
     * see the make and model of the security key.
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     * @param methodType
     *            Type of authenticator method (required)
     * @param authenticatorMethodBase
     *            (optional)
     *
     * @return AuthenticatorMethodBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorMethodBase replaceAuthenticatorMethod(String authenticatorId,
            AuthenticatorMethodType methodType, AuthenticatorMethodBase authenticatorMethodBase) throws ApiException {
        return this.replaceAuthenticatorMethod(authenticatorId, methodType, authenticatorMethodBase,
                Collections.emptyMap());
    }

    /**
     * Replace an Authenticator Method Replaces a Method of &#x60;methodType&#x60; for an Authenticator identified by
     * &#x60;authenticatorId&#x60; &gt; **Note:** &lt;x-lifecycle class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt;
     * &gt; The AAGUID Group object supports the Early Access (Self-Service) Allow List for FIDO2 (WebAuthn)
     * Authenticators feature. Enable the feature for your org from the **Settings** &gt; **Features** page in the Admin
     * Console. &gt; This feature has several limitations when enrolling a security key: &gt; - Enrollment is currently
     * unsupported on Firefox. &gt; - Enrollment is currently unsupported on Chrome if User Verification is set to
     * DISCOURAGED and a PIN is set on the security key. &gt; - If prompted during enrollment, users must allow Okta to
     * see the make and model of the security key.
     *
     * @param authenticatorId
     *            &#x60;id&#x60; of the Authenticator (required)
     * @param methodType
     *            Type of authenticator method (required)
     * @param authenticatorMethodBase
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthenticatorMethodBase
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthenticatorMethodBase replaceAuthenticatorMethod(String authenticatorId,
            AuthenticatorMethodType methodType, AuthenticatorMethodBase authenticatorMethodBase,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = authenticatorMethodBase;

        // verify the required parameter 'authenticatorId' is set
        if (authenticatorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authenticatorId' when calling replaceAuthenticatorMethod");
        }

        // verify the required parameter 'methodType' is set
        if (methodType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'methodType' when calling replaceAuthenticatorMethod");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods/{methodType}"
                .replaceAll("\\{" + "authenticatorId" + "\\}", apiClient.escapeString(authenticatorId.toString()))
                .replaceAll("\\{" + "methodType" + "\\}", apiClient.escapeString(methodType.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthenticatorMethodBase> localVarReturnType = new TypeReference<AuthenticatorMethodBase>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
