/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ApplicationPoliciesApi {

    private ApiClient apiClient;

    public ApplicationPoliciesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationPoliciesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Assign an Authentication Policy Assigns an app to an [authentication
     * policy](/openapi/okta-management/management/tag/Policy/), identified by &#x60;policyId&#x60;. If the app was
     * previously assigned to another policy, this operation replaces that assignment with the updated policy identified
     * by &#x60;policyId&#x60;. &gt; **Note:** When you [merge duplicate authentication
     * policies](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext-merge-auth-policies), the policy and
     * mapping CRUD operations may be unavailable during the consolidation. When the consolidation is complete, you
     * receive an email with merged results.
     *
     * @param appId
     *            Application ID (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignApplicationPolicy(String appId, String policyId) throws ApiException {
        this.assignApplicationPolicy(appId, policyId, Collections.emptyMap());
    }

    /**
     * Assign an Authentication Policy Assigns an app to an [authentication
     * policy](/openapi/okta-management/management/tag/Policy/), identified by &#x60;policyId&#x60;. If the app was
     * previously assigned to another policy, this operation replaces that assignment with the updated policy identified
     * by &#x60;policyId&#x60;. &gt; **Note:** When you [merge duplicate authentication
     * policies](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext-merge-auth-policies), the policy and
     * mapping CRUD operations may be unavailable during the consolidation. When the consolidation is complete, you
     * receive an email with merged results.
     *
     * @param appId
     *            Application ID (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignApplicationPolicy(String appId, String policyId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling assignApplicationPolicy");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyId' when calling assignApplicationPolicy");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/policies/{policyId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "policyId" + "\\}", apiClient.escapeString(policyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
