/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.ApplicationFeature;
import com.okta.sdk.resource.model.ApplicationFeatureType;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.UpdateFeatureForApplicationRequest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ApplicationFeaturesApi {

    private ApiClient apiClient;

    public ApplicationFeaturesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationFeaturesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve a Feature Retrieves a Feature object for an app
     *
     * @param appId
     *            Application ID (required)
     * @param featureName
     *            Name of the Feature (required)
     *
     * @return ApplicationFeature
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ApplicationFeature getFeatureForApplication(String appId, ApplicationFeatureType featureName)
            throws ApiException {
        return this.getFeatureForApplication(appId, featureName, Collections.emptyMap());
    }

    /**
     * Retrieve a Feature Retrieves a Feature object for an app
     *
     * @param appId
     *            Application ID (required)
     * @param featureName
     *            Name of the Feature (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ApplicationFeature
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ApplicationFeature getFeatureForApplication(String appId, ApplicationFeatureType featureName,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getFeatureForApplication");
        }

        // verify the required parameter 'featureName' is set
        if (featureName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'featureName' when calling getFeatureForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/features/{featureName}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "featureName" + "\\}", apiClient.escapeString(featureName.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ApplicationFeature> localVarReturnType = new TypeReference<ApplicationFeature>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Features Lists all features for an app &gt; **Note:** This request returns an error if provisioning
     * isn&#39;t enabled for the app. &gt; To set up provisioning, see [Update the default Provisioning
     * Connection](/openapi/okta-management/management/tag/ApplicationConnections/#tag/ApplicationConnections/operation/updateDefaultProvisioningConnectionForApplication).
     *
     * @param appId
     *            Application ID (required)
     *
     * @return List&lt;ApplicationFeature&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ApplicationFeature> listFeaturesForApplication(String appId) throws ApiException {
        return this.listFeaturesForApplication(appId, Collections.emptyMap());
    }

    /**
     * List all Features Lists all features for an app &gt; **Note:** This request returns an error if provisioning
     * isn&#39;t enabled for the app. &gt; To set up provisioning, see [Update the default Provisioning
     * Connection](/openapi/okta-management/management/tag/ApplicationConnections/#tag/ApplicationConnections/operation/updateDefaultProvisioningConnectionForApplication).
     *
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;ApplicationFeature&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ApplicationFeature> listFeaturesForApplication(String appId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling listFeaturesForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/features".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<ApplicationFeature>> localVarReturnType = new TypeReference<List<ApplicationFeature>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update a Feature Updates a Feature object for an app &gt; **Note:** This endpoint supports partial updates.
     *
     * @param appId
     *            Application ID (required)
     * @param featureName
     *            Name of the Feature (required)
     * @param updateFeatureForApplicationRequest
     *            (required)
     *
     * @return ApplicationFeature
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ApplicationFeature updateFeatureForApplication(String appId, ApplicationFeatureType featureName,
            UpdateFeatureForApplicationRequest updateFeatureForApplicationRequest) throws ApiException {
        return this.updateFeatureForApplication(appId, featureName, updateFeatureForApplicationRequest,
                Collections.emptyMap());
    }

    /**
     * Update a Feature Updates a Feature object for an app &gt; **Note:** This endpoint supports partial updates.
     *
     * @param appId
     *            Application ID (required)
     * @param featureName
     *            Name of the Feature (required)
     * @param updateFeatureForApplicationRequest
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ApplicationFeature
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ApplicationFeature updateFeatureForApplication(String appId, ApplicationFeatureType featureName,
            UpdateFeatureForApplicationRequest updateFeatureForApplicationRequest,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = updateFeatureForApplicationRequest;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling updateFeatureForApplication");
        }

        // verify the required parameter 'featureName' is set
        if (featureName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'featureName' when calling updateFeatureForApplication");
        }

        // verify the required parameter 'updateFeatureForApplicationRequest' is set
        if (updateFeatureForApplicationRequest == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'updateFeatureForApplicationRequest' when calling updateFeatureForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/features/{featureName}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "featureName" + "\\}", apiClient.escapeString(featureName.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ApplicationFeature> localVarReturnType = new TypeReference<ApplicationFeature>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
