# SsfReceiverApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**activateSecurityEventsProviderInstance**](SsfReceiverApi.md#activateSecurityEventsProviderInstance) | **POST** /api/v1/security-events-providers/{securityEventProviderId}/lifecycle/activate | Activate a Security Events Provider |
| [**createSecurityEventsProviderInstance**](SsfReceiverApi.md#createSecurityEventsProviderInstance) | **POST** /api/v1/security-events-providers | Create a Security Events Provider |
| [**deactivateSecurityEventsProviderInstance**](SsfReceiverApi.md#deactivateSecurityEventsProviderInstance) | **POST** /api/v1/security-events-providers/{securityEventProviderId}/lifecycle/deactivate | Deactivate a Security Events Provider |
| [**deleteSecurityEventsProviderInstance**](SsfReceiverApi.md#deleteSecurityEventsProviderInstance) | **DELETE** /api/v1/security-events-providers/{securityEventProviderId} | Delete a Security Events Provider |
| [**getSecurityEventsProviderInstance**](SsfReceiverApi.md#getSecurityEventsProviderInstance) | **GET** /api/v1/security-events-providers/{securityEventProviderId} | Retrieve the Security Events Provider |
| [**listSecurityEventsProviderInstances**](SsfReceiverApi.md#listSecurityEventsProviderInstances) | **GET** /api/v1/security-events-providers | List all Security Events Providers |
| [**replaceSecurityEventsProviderInstance**](SsfReceiverApi.md#replaceSecurityEventsProviderInstance) | **PUT** /api/v1/security-events-providers/{securityEventProviderId} | Replace a Security Events Provider |



## activateSecurityEventsProviderInstance

> SecurityEventsProviderResponse activateSecurityEventsProviderInstance(securityEventProviderId)

Activate a Security Events Provider

Activates a Security Events Provider instance by setting its status to &#x60;ACTIVE&#x60;. This operation resumes the flow of events from the Security Events Provider to Okta.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.SsfReceiverApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        SsfReceiverApi apiInstance = new SsfReceiverApi(defaultClient);
        String securityEventProviderId = "sse1qg25RpusjUP6m0g5"; // String | `id` of the Security Events Provider instance
        try {
            SecurityEventsProviderResponse result = apiInstance.activateSecurityEventsProviderInstance(securityEventProviderId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling SsfReceiverApi#activateSecurityEventsProviderInstance");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **securityEventProviderId** | **String**| &#x60;id&#x60; of the Security Events Provider instance | |

### Return type

[**SecurityEventsProviderResponse**](SecurityEventsProviderResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## createSecurityEventsProviderInstance

> SecurityEventsProviderResponse createSecurityEventsProviderInstance(instance)

Create a Security Events Provider

Creates a Security Events Provider instance

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.SsfReceiverApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        SsfReceiverApi apiInstance = new SsfReceiverApi(defaultClient);
        SecurityEventsProviderRequest instance = new SecurityEventsProviderRequest(); // SecurityEventsProviderRequest | 
        try {
            SecurityEventsProviderResponse result = apiInstance.createSecurityEventsProviderInstance(instance);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling SsfReceiverApi#createSecurityEventsProviderInstance");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **instance** | [**SecurityEventsProviderRequest**](SecurityEventsProviderRequest.md)|  | |

### Return type

[**SecurityEventsProviderResponse**](SecurityEventsProviderResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## deactivateSecurityEventsProviderInstance

> SecurityEventsProviderResponse deactivateSecurityEventsProviderInstance(securityEventProviderId)

Deactivate a Security Events Provider

Deactivates a Security Events Provider instance by setting its status to &#x60;INACTIVE&#x60;. This operation stops the flow of events from the Security Events Provider to Okta.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.SsfReceiverApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        SsfReceiverApi apiInstance = new SsfReceiverApi(defaultClient);
        String securityEventProviderId = "sse1qg25RpusjUP6m0g5"; // String | `id` of the Security Events Provider instance
        try {
            SecurityEventsProviderResponse result = apiInstance.deactivateSecurityEventsProviderInstance(securityEventProviderId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling SsfReceiverApi#deactivateSecurityEventsProviderInstance");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **securityEventProviderId** | **String**| &#x60;id&#x60; of the Security Events Provider instance | |

### Return type

[**SecurityEventsProviderResponse**](SecurityEventsProviderResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteSecurityEventsProviderInstance

> deleteSecurityEventsProviderInstance(securityEventProviderId)

Delete a Security Events Provider

Deletes a Security Events Provider instance specified by &#x60;id&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.SsfReceiverApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        SsfReceiverApi apiInstance = new SsfReceiverApi(defaultClient);
        String securityEventProviderId = "sse1qg25RpusjUP6m0g5"; // String | `id` of the Security Events Provider instance
        try {
            apiInstance.deleteSecurityEventsProviderInstance(securityEventProviderId);
        } catch (ApiException e) {
            System.err.println("Exception when calling SsfReceiverApi#deleteSecurityEventsProviderInstance");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **securityEventProviderId** | **String**| &#x60;id&#x60; of the Security Events Provider instance | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getSecurityEventsProviderInstance

> SecurityEventsProviderResponse getSecurityEventsProviderInstance(securityEventProviderId)

Retrieve the Security Events Provider

Retrieves the Security Events Provider instance specified by &#x60;id&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.SsfReceiverApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        SsfReceiverApi apiInstance = new SsfReceiverApi(defaultClient);
        String securityEventProviderId = "sse1qg25RpusjUP6m0g5"; // String | `id` of the Security Events Provider instance
        try {
            SecurityEventsProviderResponse result = apiInstance.getSecurityEventsProviderInstance(securityEventProviderId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling SsfReceiverApi#getSecurityEventsProviderInstance");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **securityEventProviderId** | **String**| &#x60;id&#x60; of the Security Events Provider instance | |

### Return type

[**SecurityEventsProviderResponse**](SecurityEventsProviderResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listSecurityEventsProviderInstances

> List&lt;SecurityEventsProviderResponse&gt; listSecurityEventsProviderInstances()

List all Security Events Providers

Lists all Security Events Provider instances

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.SsfReceiverApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        SsfReceiverApi apiInstance = new SsfReceiverApi(defaultClient);
        try {
            List<SecurityEventsProviderResponse> result = apiInstance.listSecurityEventsProviderInstances();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling SsfReceiverApi#listSecurityEventsProviderInstances");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**List&lt;SecurityEventsProviderResponse&gt;**](SecurityEventsProviderResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## replaceSecurityEventsProviderInstance

> SecurityEventsProviderResponse replaceSecurityEventsProviderInstance(securityEventProviderId, instance)

Replace a Security Events Provider

Replaces a Security Events Provider instance specified by &#x60;id&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.SsfReceiverApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        SsfReceiverApi apiInstance = new SsfReceiverApi(defaultClient);
        String securityEventProviderId = "sse1qg25RpusjUP6m0g5"; // String | `id` of the Security Events Provider instance
        SecurityEventsProviderRequest instance = new SecurityEventsProviderRequest(); // SecurityEventsProviderRequest | 
        try {
            SecurityEventsProviderResponse result = apiInstance.replaceSecurityEventsProviderInstance(securityEventProviderId, instance);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling SsfReceiverApi#replaceSecurityEventsProviderInstance");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **securityEventProviderId** | **String**| &#x60;id&#x60; of the Security Events Provider instance | |
| **instance** | [**SecurityEventsProviderRequest**](SecurityEventsProviderRequest.md)|  | |

### Return type

[**SecurityEventsProviderResponse**](SecurityEventsProviderResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

