

# SamlApplicationSettingsSignOn

SAML 2.0 sign-on attributes. > **Note:** Set either `destinationOverride` or `ssoAcsUrl` to configure any other SAML 2.0 attributes in this section.

## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**acsEndpoints** | [**List&lt;AcsEndpoint&gt;**](AcsEndpoint.md) | An array of ACS endpoints. You can configure a maximum of 100 endpoints. |  [optional] |
|**allowMultipleAcsEndpoints** | **Boolean** | Determines whether the app allows you to configure multiple ACS URIs |  |
|**assertionSigned** | **Boolean** | Determines whether the SAML assertion is digitally signed |  |
|**attributeStatements** | [**List&lt;SamlAttributeStatement&gt;**](SamlAttributeStatement.md) | A list of custom attribute statements for the app&#39;s SAML assertion. See [SAML 2.0 Technical Overview](https://docs.oasis-open.org/security/saml/Post2.0/sstc-saml-tech-overview-2.0-cd-02.html).  There are two types of attribute statements: | Type | Description | | ---- | ----------- | | EXPRESSION | Generic attribute statement that can be dynamic and supports [Okta Expression Language](https://developer.okta.com/docs/reference/okta-expression-language/) | | GROUP | Group attribute statement |  |  [optional] |
|**audience** | **String** | The entity ID of the SP. Use the entity ID value exactly as provided by the SP. |  |
|**audienceOverride** | **String** | Audience override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm). |  [optional] |
|**authnContextClassRef** | **String** | Identifies the SAML authentication context class for the assertion&#39;s authentication statement |  |
|**configuredAttributeStatements** | [**List&lt;SamlAttributeStatement&gt;**](SamlAttributeStatement.md) | The list of dynamic attribute statements for the SAML assertion inherited from app metadata (apps from the OIN) during app creation.  There are two types of attribute statements: &#x60;EXPRESSION&#x60; and &#x60;GROUP&#x60;.  |  [optional] |
|**defaultRelayState** | **String** | Identifies a specific application resource in an IdP-initiated SSO scenario |  [optional] |
|**destination** | **String** | Identifies the location inside the SAML assertion where the SAML response should be sent |  |
|**destinationOverride** | **String** | Destination override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm). |  [optional] |
|**digestAlgorithm** | **String** | Determines the digest algorithm used to digitally sign the SAML assertion and response |  |
|**honorForceAuthn** | **Boolean** | Set to &#x60;true&#x60; to prompt users for their credentials when a SAML request has the &#x60;ForceAuthn&#x60; attribute set to &#x60;true&#x60; |  |
|**idpIssuer** | **String** | SAML Issuer ID |  |
|**inlineHooks** | [**List&lt;SignOnInlineHook&gt;**](SignOnInlineHook.md) | Associates the app with SAML inline hooks. See [the SAML assertion inline hook reference](https://developer.okta.com/docs/reference/saml-hook/). |  [optional] |
|**participateSlo** | [**SloParticipate**](SloParticipate.md) |  |  [optional] |
|**recipient** | **String** | The location where the app may present the SAML assertion |  |
|**recipientOverride** | **String** | Recipient override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm). |  [optional] |
|**requestCompressed** | **Boolean** | Determines whether the SAML request is expected to be compressed |  |
|**responseSigned** | **Boolean** | Determines whether the SAML authentication response message is digitally signed by the IdP &gt; **Note:** Either (or both) &#x60;responseSigned&#x60; or &#x60;assertionSigned&#x60; must be &#x60;TRUE&#x60;. |  |
|**samlAssertionLifetimeSeconds** | **Integer** | Determines the SAML app session lifetimes with Okta |  [optional] |
|**signatureAlgorithm** | **String** | Determines the signing algorithm used to digitally sign the SAML assertion and response |  |
|**slo** | [**SingleLogout**](SingleLogout.md) |  |  [optional] |
|**spCertificate** | [**SamlSpCertificate**](SamlSpCertificate.md) |  |  [optional] |
|**spIssuer** | **String** | The issuer ID for the Service Provider. This property appears when SLO is enabled. |  [optional] |
|**ssoAcsUrl** | **String** | Single Sign-On Assertion Consumer Service (ACS) URL |  |
|**ssoAcsUrlOverride** | **String** | Assertion Consumer Service (ACS) URL override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm). |  [optional] |
|**subjectNameIdFormat** | **String** |  |  |
|**subjectNameIdTemplate** | **String** | Template for app user&#39;s username when a user is assigned to the app |  |


## Implemented Interfaces

* Serializable


