# RoleDResourceSetBindingMemberApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**addMembersToBinding**](RoleDResourceSetBindingMemberApi.md#addMembersToBinding) | **PATCH** /api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}/members | Add more Role Resource Set Binding Members |
| [**getMemberOfBinding**](RoleDResourceSetBindingMemberApi.md#getMemberOfBinding) | **GET** /api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}/members/{memberId} | Retrieve a Role Resource Set Binding Member |
| [**listMembersOfBinding**](RoleDResourceSetBindingMemberApi.md#listMembersOfBinding) | **GET** /api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}/members | List all Role Resource Set Binding Members |
| [**unassignMemberFromBinding**](RoleDResourceSetBindingMemberApi.md#unassignMemberFromBinding) | **DELETE** /api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}/members/{memberId} | Unassign a Role Resource Set Bindiing Member |



## addMembersToBinding

> ResourceSetBindingResponse addMembersToBinding(resourceSetIdOrLabel, roleIdOrLabel, instance)

Add more Role Resource Set Binding Members

Adds more members to a Role Resource Set Binding

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleDResourceSetBindingMemberApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleDResourceSetBindingMemberApi apiInstance = new RoleDResourceSetBindingMemberApi(defaultClient);
        String resourceSetIdOrLabel = "iamoJDFKaJxGIr0oamd9g"; // String | `id` or `label` the Resource Set
        String roleIdOrLabel = "cr0Yq6IJxGIr0ouum0g3"; // String | `id` or `label` of the Role
        ResourceSetBindingAddMembersRequest instance = new ResourceSetBindingAddMembersRequest(); // ResourceSetBindingAddMembersRequest | 
        try {
            ResourceSetBindingResponse result = apiInstance.addMembersToBinding(resourceSetIdOrLabel, roleIdOrLabel, instance);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleDResourceSetBindingMemberApi#addMembersToBinding");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **resourceSetIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; the Resource Set | |
| **roleIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; of the Role | |
| **instance** | [**ResourceSetBindingAddMembersRequest**](ResourceSetBindingAddMembersRequest.md)|  | |

### Return type

[**ResourceSetBindingResponse**](ResourceSetBindingResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getMemberOfBinding

> ResourceSetBindingMember getMemberOfBinding(resourceSetIdOrLabel, roleIdOrLabel, memberId)

Retrieve a Role Resource Set Binding Member

Retrieves a Member (identified by &#x60;memberId&#x60;) that belongs to a Role Resource Set Binding

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleDResourceSetBindingMemberApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleDResourceSetBindingMemberApi apiInstance = new RoleDResourceSetBindingMemberApi(defaultClient);
        String resourceSetIdOrLabel = "iamoJDFKaJxGIr0oamd9g"; // String | `id` or `label` the Resource Set
        String roleIdOrLabel = "cr0Yq6IJxGIr0ouum0g3"; // String | `id` or `label` of the Role
        String memberId = "irb1qe6PGuMc7Oh8N0g4"; // String | `id` of the Member
        try {
            ResourceSetBindingMember result = apiInstance.getMemberOfBinding(resourceSetIdOrLabel, roleIdOrLabel, memberId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleDResourceSetBindingMemberApi#getMemberOfBinding");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **resourceSetIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; the Resource Set | |
| **roleIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; of the Role | |
| **memberId** | **String**| &#x60;id&#x60; of the Member | |

### Return type

[**ResourceSetBindingMember**](ResourceSetBindingMember.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listMembersOfBinding

> ResourceSetBindingMembers listMembersOfBinding(resourceSetIdOrLabel, roleIdOrLabel, after)

List all Role Resource Set Binding Members

Lists all members of a Role Resource Set Binding with pagination support

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleDResourceSetBindingMemberApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleDResourceSetBindingMemberApi apiInstance = new RoleDResourceSetBindingMemberApi(defaultClient);
        String resourceSetIdOrLabel = "iamoJDFKaJxGIr0oamd9g"; // String | `id` or `label` the Resource Set
        String roleIdOrLabel = "cr0Yq6IJxGIr0ouum0g3"; // String | `id` or `label` of the Role
        String after = "after_example"; // String | The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the `Link` response header. See [Pagination](https://developer.okta.com/docs/api/#pagination).
        try {
            ResourceSetBindingMembers result = apiInstance.listMembersOfBinding(resourceSetIdOrLabel, roleIdOrLabel, after);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleDResourceSetBindingMemberApi#listMembersOfBinding");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **resourceSetIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; the Resource Set | |
| **roleIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; of the Role | |
| **after** | **String**| The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](https://developer.okta.com/docs/api/#pagination). | [optional] |

### Return type

[**ResourceSetBindingMembers**](ResourceSetBindingMembers.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## unassignMemberFromBinding

> unassignMemberFromBinding(resourceSetIdOrLabel, roleIdOrLabel, memberId)

Unassign a Role Resource Set Bindiing Member

Unassigns a Member (identified by &#x60;memberId&#x60;) from a Role Resource Set Binding

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleDResourceSetBindingMemberApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleDResourceSetBindingMemberApi apiInstance = new RoleDResourceSetBindingMemberApi(defaultClient);
        String resourceSetIdOrLabel = "iamoJDFKaJxGIr0oamd9g"; // String | `id` or `label` the Resource Set
        String roleIdOrLabel = "cr0Yq6IJxGIr0ouum0g3"; // String | `id` or `label` of the Role
        String memberId = "irb1qe6PGuMc7Oh8N0g4"; // String | `id` of the Member
        try {
            apiInstance.unassignMemberFromBinding(resourceSetIdOrLabel, roleIdOrLabel, memberId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleDResourceSetBindingMemberApi#unassignMemberFromBinding");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **resourceSetIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; the Resource Set | |
| **roleIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; of the Role | |
| **memberId** | **String**| &#x60;id&#x60; of the Member | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

