# RoleBTargetClientApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**assignAppTargetInstanceRoleForClient**](RoleBTargetClientApi.md#assignAppTargetInstanceRoleForClient) | **PUT** /oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId} | Assign a Client Role Application Instance Target |
| [**assignAppTargetRoleToClient**](RoleBTargetClientApi.md#assignAppTargetRoleToClient) | **PUT** /oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName} | Assign a Client Role Application Target |
| [**assignGroupTargetRoleForClient**](RoleBTargetClientApi.md#assignGroupTargetRoleForClient) | **PUT** /oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/groups/{groupId} | Assign a Client Role Group Target |
| [**listAppTargetRoleToClient**](RoleBTargetClientApi.md#listAppTargetRoleToClient) | **GET** /oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps | List all Client Role Application Targets |
| [**listGroupTargetRoleForClient**](RoleBTargetClientApi.md#listGroupTargetRoleForClient) | **GET** /oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/groups | List all Client Role Group Targets |
| [**removeAppTargetInstanceRoleForClient**](RoleBTargetClientApi.md#removeAppTargetInstanceRoleForClient) | **DELETE** /oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId} | Unassign a Client Role Application Instance Target |
| [**removeAppTargetRoleFromClient**](RoleBTargetClientApi.md#removeAppTargetRoleFromClient) | **DELETE** /oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName} | Unassign a Client Role Application Target |
| [**removeGroupTargetRoleFromClient**](RoleBTargetClientApi.md#removeGroupTargetRoleFromClient) | **DELETE** /oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/groups/{groupId} | Unassign a Client Role Group Target |



## assignAppTargetInstanceRoleForClient

> assignAppTargetInstanceRoleForClient(clientId, roleAssignmentId, appName, appId)

Assign a Client Role Application Instance Target

Assigns an app instance target to an &#x60;APP_ADMIN&#x60; Role Assignment to a client Application. When you assign the first OIN app or app instance target, you reduce the scope of the Role Assignment. The Role no longer applies to all app targets, but applies only to the specified target.  &gt; **Note:** You can target a mixture of both OIN app and app instance targets, but you can&#39;t assign permissions to manage all instances of an OIN app and then assign a subset of permissions to the same app. For example, you can&#39;t specify that an admin has access to manage all instances of the Salesforce app and then also manage only specific configurations of the Salesforce app.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetClientApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetClientApi apiInstance = new RoleBTargetClientApi(defaultClient);
        String clientId = "52Uy4BUWVBOjFItcg2jWsmnd83Ad8dD"; // String | `client_id` of the app
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String appName = "oidc_client"; // String | Application name for the app type
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        try {
            apiInstance.assignAppTargetInstanceRoleForClient(clientId, roleAssignmentId, appName, appId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetClientApi#assignAppTargetInstanceRoleForClient");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **clientId** | **String**| &#x60;client_id&#x60; of the app | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **appName** | **String**| Application name for the app type | |
| **appId** | **String**| Application ID | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## assignAppTargetRoleToClient

> assignAppTargetRoleToClient(clientId, roleAssignmentId, appName)

Assign a Client Role Application Target

Assigns an OIN app target for an &#x60;APP_ADMIN&#x60; Role Assignment to a client Application. When you assign an app target from the OIN catalog, you reduce the scope of the Role Assignment. The Role applies to only app instances that are included in the specified OIN app target.  An assigned OIN app target overrides any existing app instance targets. For example, if a user is assigned to administer a specific Facebook instance, a successful request to add an OIN app target with &#x60;facebook&#x60; for &#x60;appName&#x60; makes that user the administrator for all Facebook instances.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetClientApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetClientApi apiInstance = new RoleBTargetClientApi(defaultClient);
        String clientId = "52Uy4BUWVBOjFItcg2jWsmnd83Ad8dD"; // String | `client_id` of the app
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String appName = "oidc_client"; // String | Application name for the app type
        try {
            apiInstance.assignAppTargetRoleToClient(clientId, roleAssignmentId, appName);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetClientApi#assignAppTargetRoleToClient");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **clientId** | **String**| &#x60;client_id&#x60; of the app | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **appName** | **String**| Application name for the app type | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## assignGroupTargetRoleForClient

> assignGroupTargetRoleForClient(clientId, roleAssignmentId, groupId)

Assign a Client Role Group Target

Assigns a Group target to a &#x60;USER_ADMIN&#x60;, &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to a client Application. When you assign the first Group target, you reduce the scope of the Role Assignment. The Role no longer applies to all targets, but applies only to the specified target.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetClientApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetClientApi apiInstance = new RoleBTargetClientApi(defaultClient);
        String clientId = "52Uy4BUWVBOjFItcg2jWsmnd83Ad8dD"; // String | `client_id` of the app
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        try {
            apiInstance.assignGroupTargetRoleForClient(clientId, roleAssignmentId, groupId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetClientApi#assignGroupTargetRoleForClient");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **clientId** | **String**| &#x60;client_id&#x60; of the app | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **groupId** | **String**| The &#x60;id&#x60; of the group | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listAppTargetRoleToClient

> List&lt;CatalogApplication&gt; listAppTargetRoleToClient(clientId, roleAssignmentId, after, limit)

List all Client Role Application Targets

Lists all OIN app targets for an &#x60;APP_ADMIN&#x60;  Role that&#39;s assigned to a client Application (by &#x60;clientId&#x60;).

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetClientApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetClientApi apiInstance = new RoleBTargetClientApi(defaultClient);
        String clientId = "52Uy4BUWVBOjFItcg2jWsmnd83Ad8dD"; // String | `client_id` of the app
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String after = "after_example"; // String | The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the `Link` response header. See [Pagination](https://developer.okta.com/docs/api/#pagination).
        Integer limit = 20; // Integer | A limit on the number of objects to return
        try {
            List<CatalogApplication> result = apiInstance.listAppTargetRoleToClient(clientId, roleAssignmentId, after, limit);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetClientApi#listAppTargetRoleToClient");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **clientId** | **String**| &#x60;client_id&#x60; of the app | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **after** | **String**| The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](https://developer.okta.com/docs/api/#pagination). | [optional] |
| **limit** | **Integer**| A limit on the number of objects to return | [optional] [default to 20] |

### Return type

[**List&lt;CatalogApplication&gt;**](CatalogApplication.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listGroupTargetRoleForClient

> List&lt;Group&gt; listGroupTargetRoleForClient(clientId, roleAssignmentId, after, limit)

List all Client Role Group Targets

Lists all Group targets for a &#x60;USER_ADMIN&#x60;, &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to a client. If the Role isn&#39;t scoped to specific Group targets, an empty array &#x60;[]&#x60; is returned.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetClientApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetClientApi apiInstance = new RoleBTargetClientApi(defaultClient);
        String clientId = "52Uy4BUWVBOjFItcg2jWsmnd83Ad8dD"; // String | `client_id` of the app
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String after = "after_example"; // String | The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the `Link` response header. See [Pagination](https://developer.okta.com/docs/api/#pagination).
        Integer limit = 20; // Integer | A limit on the number of objects to return
        try {
            List<Group> result = apiInstance.listGroupTargetRoleForClient(clientId, roleAssignmentId, after, limit);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetClientApi#listGroupTargetRoleForClient");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **clientId** | **String**| &#x60;client_id&#x60; of the app | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **after** | **String**| The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](https://developer.okta.com/docs/api/#pagination). | [optional] |
| **limit** | **Integer**| A limit on the number of objects to return | [optional] [default to 20] |

### Return type

[**List&lt;Group&gt;**](Group.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## removeAppTargetInstanceRoleForClient

> removeAppTargetInstanceRoleForClient(clientId, roleAssignmentId, appName, appId)

Unassign a Client Role Application Instance Target

Unassigns an OIN app instance target from a Role Assignment to a client Application  &gt; **Note:** You can&#39;t remove the last app instance target from a Role Assignment since this causes an exception. &gt; If you need a Role Assignment that applies to all the apps, delete the Role Assignment and recreate a new one.  See [Unassign a Client Role](/openapi/okta-management/management/tag/RoleAssignmentClient/#tag/RoleAssignmentClient/operation/deleteRoleFromClient).

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetClientApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetClientApi apiInstance = new RoleBTargetClientApi(defaultClient);
        String clientId = "52Uy4BUWVBOjFItcg2jWsmnd83Ad8dD"; // String | `client_id` of the app
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String appName = "oidc_client"; // String | Application name for the app type
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        try {
            apiInstance.removeAppTargetInstanceRoleForClient(clientId, roleAssignmentId, appName, appId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetClientApi#removeAppTargetInstanceRoleForClient");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **clientId** | **String**| &#x60;client_id&#x60; of the app | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **appName** | **String**| Application name for the app type | |
| **appId** | **String**| Application ID | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## removeAppTargetRoleFromClient

> removeAppTargetRoleFromClient(clientId, roleAssignmentId, appName)

Unassign a Client Role Application Target

Unassigns an OIN app target for a Role Assignment to a client Application  &gt; **Note:** You can&#39;t remove the last OIN app target from a Role Assignment since operation causes an exception. &gt; If you need a Role assignment that applies to all apps, delete the Role Assignment and recreate a new one. See [Unassign a Client Role](/openapi/okta-management/management/tag/RoleAssignmentClient/#tag/RoleAssignmentClient/operation/deleteRoleFromClient).

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetClientApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetClientApi apiInstance = new RoleBTargetClientApi(defaultClient);
        String clientId = "52Uy4BUWVBOjFItcg2jWsmnd83Ad8dD"; // String | `client_id` of the app
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String appName = "oidc_client"; // String | Application name for the app type
        try {
            apiInstance.removeAppTargetRoleFromClient(clientId, roleAssignmentId, appName);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetClientApi#removeAppTargetRoleFromClient");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **clientId** | **String**| &#x60;client_id&#x60; of the app | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **appName** | **String**| Application name for the app type | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## removeGroupTargetRoleFromClient

> removeGroupTargetRoleFromClient(clientId, roleAssignmentId, groupId)

Unassign a Client Role Group Target

Unassigns a Group target from a &#x60;USER_ADMIN&#x60;, &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to a client Application.  &gt; **Note:** You can&#39;t remove the last Group target from a Role Assignment, as it causes an exception. If you need a Role Assignment that applies to all Groups, delete the Role Assignment and recreate a new one. See [Unassign a Client Role](/openapi/okta-management/management/tag/RoleAssignmentClient/#tag/RoleAssignmentClient/operation/deleteRoleFromClient).

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetClientApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetClientApi apiInstance = new RoleBTargetClientApi(defaultClient);
        String clientId = "52Uy4BUWVBOjFItcg2jWsmnd83Ad8dD"; // String | `client_id` of the app
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        try {
            apiInstance.removeGroupTargetRoleFromClient(clientId, roleAssignmentId, groupId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetClientApi#removeGroupTargetRoleFromClient");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **clientId** | **String**| &#x60;client_id&#x60; of the app | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **groupId** | **String**| The &#x60;id&#x60; of the group | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

