# RoleBTargetAdminApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**assignAllAppsAsTargetToRoleForUser**](RoleBTargetAdminApi.md#assignAllAppsAsTargetToRoleForUser) | **PUT** /api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps | Assign all Apps as Target to Role |
| [**assignAppInstanceTargetToAppAdminRoleForUser**](RoleBTargetAdminApi.md#assignAppInstanceTargetToAppAdminRoleForUser) | **PUT** /api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId} | Assign an Admin Role Application Instance Target |
| [**assignAppTargetToAdminRoleForUser**](RoleBTargetAdminApi.md#assignAppTargetToAdminRoleForUser) | **PUT** /api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName} | Assign an Admin Role Application Target |
| [**assignGroupTargetToUserRole**](RoleBTargetAdminApi.md#assignGroupTargetToUserRole) | **PUT** /api/v1/users/{userId}/roles/{roleAssignmentId}/targets/groups/{groupId} | Assign an Admin Role Group Target |
| [**listApplicationTargetsForApplicationAdministratorRoleForUser**](RoleBTargetAdminApi.md#listApplicationTargetsForApplicationAdministratorRoleForUser) | **GET** /api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps | List all Admin Role Application Targets |
| [**listGroupTargetsForRole**](RoleBTargetAdminApi.md#listGroupTargetsForRole) | **GET** /api/v1/users/{userId}/roles/{roleAssignmentId}/targets/groups | List all Admin Role Group Targets |
| [**unassignAppInstanceTargetFromAdminRoleForUser**](RoleBTargetAdminApi.md#unassignAppInstanceTargetFromAdminRoleForUser) | **DELETE** /api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId} | Unassign an Admin Role Application Instance Target |
| [**unassignAppTargetFromAppAdminRoleForUser**](RoleBTargetAdminApi.md#unassignAppTargetFromAppAdminRoleForUser) | **DELETE** /api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName} | Unassign an Admin Role Application Target |
| [**unassignGroupTargetFromUserAdminRole**](RoleBTargetAdminApi.md#unassignGroupTargetFromUserAdminRole) | **DELETE** /api/v1/users/{userId}/roles/{roleAssignmentId}/targets/groups/{groupId} | Unassign an Admin Role Group Target |



## assignAllAppsAsTargetToRoleForUser

> assignAllAppsAsTargetToRoleForUser(userId, roleAssignmentId)

Assign all Apps as Target to Role

Assigns all Apps as Target to Role

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetAdminApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetAdminApi apiInstance = new RoleBTargetAdminApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        try {
            apiInstance.assignAllAppsAsTargetToRoleForUser(userId, roleAssignmentId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetAdminApi#assignAllAppsAsTargetToRoleForUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## assignAppInstanceTargetToAppAdminRoleForUser

> assignAppInstanceTargetToAppAdminRoleForUser(userId, roleAssignmentId, appName, appId)

Assign an Admin Role Application Instance Target

Assigns an app instance target to an &#x60;APP_ADMIN&#x60; Role Assignment to an admin User. When you assign the first OIN app or app instance target, you reduce the scope of the Role Assignment. The Role no longer applies to all app targets, but applies only to the specified target.               &gt; **Note:** You can target a mixture of both OIN app and app instance targets, but can&#39;t assign permissions to manage all instances of an OIN app and then assign a subset of permission to the same OIN app. &gt; For example, you can&#39;t specify that an admin has access to manage all instances of the Salesforce app and then also manage specific configurations of the Salesforce app. 

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetAdminApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetAdminApi apiInstance = new RoleBTargetAdminApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String appName = "oidc_client"; // String | Application name for the app type
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        try {
            apiInstance.assignAppInstanceTargetToAppAdminRoleForUser(userId, roleAssignmentId, appName, appId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetAdminApi#assignAppInstanceTargetToAppAdminRoleForUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **appName** | **String**| Application name for the app type | |
| **appId** | **String**| Application ID | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## assignAppTargetToAdminRoleForUser

> assignAppTargetToAdminRoleForUser(userId, roleAssignmentId, appName)

Assign an Admin Role Application Target

Assigns an OIN app target for an &#x60;APP_ADMIN&#x60; Role Assignment to an admin User. When you assign the first app target, you reduce the scope of the Role Assignment. The Role no longer applies to all app targets, but applies only to the specified target. Assigning an OIN app target overrides any existing app instance targets of the OIN app. For example, if a user was assigned to administer a specific Facebook instance, a successful request to add an OIN app target with &#x60;facebook&#x60; for &#x60;appName&#x60; makes that user the administrator for all Facebook instances. 

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetAdminApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetAdminApi apiInstance = new RoleBTargetAdminApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String appName = "oidc_client"; // String | Application name for the app type
        try {
            apiInstance.assignAppTargetToAdminRoleForUser(userId, roleAssignmentId, appName);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetAdminApi#assignAppTargetToAdminRoleForUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **appName** | **String**| Application name for the app type | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## assignGroupTargetToUserRole

> assignGroupTargetToUserRole(userId, roleAssignmentId, groupId)

Assign an Admin Role Group Target

Assigns a Group target for a &#x60;USER_ADMIN&#x60;, &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to an admin User. When you assign the first Group target, you reduce the scope of the Role Assignment. The Role no longer applies to all targets but applies only to the specified target. 

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetAdminApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetAdminApi apiInstance = new RoleBTargetAdminApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        try {
            apiInstance.assignGroupTargetToUserRole(userId, roleAssignmentId, groupId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetAdminApi#assignGroupTargetToUserRole");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **groupId** | **String**| The &#x60;id&#x60; of the group | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listApplicationTargetsForApplicationAdministratorRoleForUser

> List&lt;CatalogApplication&gt; listApplicationTargetsForApplicationAdministratorRoleForUser(userId, roleAssignmentId, after, limit)

List all Admin Role Application Targets

Lists all app targets for an &#x60;APP_ADMIN&#x60; Role Assigned to a User. The response is a list that includes OIN-cataloged apps or app instances. The response payload for an app instance contains the &#x60;id&#x60; property, but an OIN-cataloged app payload doesn&#39;t.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetAdminApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetAdminApi apiInstance = new RoleBTargetAdminApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String after = "after_example"; // String | 
        Integer limit = 20; // Integer | 
        try {
            List<CatalogApplication> result = apiInstance.listApplicationTargetsForApplicationAdministratorRoleForUser(userId, roleAssignmentId, after, limit);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetAdminApi#listApplicationTargetsForApplicationAdministratorRoleForUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **after** | **String**|  | [optional] |
| **limit** | **Integer**|  | [optional] [default to 20] |

### Return type

[**List&lt;CatalogApplication&gt;**](CatalogApplication.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listGroupTargetsForRole

> List&lt;Group&gt; listGroupTargetsForRole(userId, roleAssignmentId, after, limit)

List all Admin Role Group Targets

Lists all Group targets for a &#x60;USER_ADMIN&#x60;, &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to an admin User. If the Role isn&#39;t scoped to specific Group targets, an empty array &#x60;[]&#x60; is returned. 

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetAdminApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetAdminApi apiInstance = new RoleBTargetAdminApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String after = "after_example"; // String | 
        Integer limit = 20; // Integer | 
        try {
            List<Group> result = apiInstance.listGroupTargetsForRole(userId, roleAssignmentId, after, limit);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetAdminApi#listGroupTargetsForRole");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **after** | **String**|  | [optional] |
| **limit** | **Integer**|  | [optional] [default to 20] |

### Return type

[**List&lt;Group&gt;**](Group.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## unassignAppInstanceTargetFromAdminRoleForUser

> unassignAppInstanceTargetFromAdminRoleForUser(userId, roleAssignmentId, appName, appId)

Unassign an Admin Role Application Instance Target

Unassigns an app instance target from an &#x60;APP_ADMIN&#x60; Role Assignment to an admin User.  &gt; **Note:** You can&#39;t remove the last app instance target from a Role Assignment since this causes an exception. &gt; If you need a Role Assignment that applies to all apps, delete the &#x60;APP_ADMIN&#x60; Role Assignment and recreate a new one.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetAdminApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetAdminApi apiInstance = new RoleBTargetAdminApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String appName = "oidc_client"; // String | Application name for the app type
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        try {
            apiInstance.unassignAppInstanceTargetFromAdminRoleForUser(userId, roleAssignmentId, appName, appId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetAdminApi#unassignAppInstanceTargetFromAdminRoleForUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **appName** | **String**| Application name for the app type | |
| **appId** | **String**| Application ID | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## unassignAppTargetFromAppAdminRoleForUser

> unassignAppTargetFromAppAdminRoleForUser(userId, roleAssignmentId, appName)

Unassign an Admin Role Application Target

Unassigns an OIN app target from an &#x60;APP_ADMIN&#x60; Role Assignment to an admin User.  &gt; **Note:** You can&#39;t remove the last OIN app target from a Role Assignment since this causes an exception. &gt; If you need a Role Assignment that applies to all apps, delete the &#x60;APP_ADMIN&#x60; Role Assignment to the User and recreate a new one. 

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetAdminApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetAdminApi apiInstance = new RoleBTargetAdminApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String appName = "oidc_client"; // String | Application name for the app type
        try {
            apiInstance.unassignAppTargetFromAppAdminRoleForUser(userId, roleAssignmentId, appName);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetAdminApi#unassignAppTargetFromAppAdminRoleForUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **appName** | **String**| Application name for the app type | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## unassignGroupTargetFromUserAdminRole

> unassignGroupTargetFromUserAdminRole(userId, roleAssignmentId, groupId)

Unassign an Admin Role Group Target

Unassigns a Group target from a &#x60;USER_ADMIN&#x60;, &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to an admin User.  &gt; **Note:** You can&#39;t remove the last Group target from a Role Assignment since this causes an exception. &gt; If you need a Role Assignment that applies to all Groups, delete the Role Assignment to the User and recreate a new one. 

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetAdminApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetAdminApi apiInstance = new RoleBTargetAdminApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        try {
            apiInstance.unassignGroupTargetFromUserAdminRole(userId, roleAssignmentId, groupId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetAdminApi#unassignGroupTargetFromUserAdminRole");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **groupId** | **String**| The &#x60;id&#x60; of the group | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

