

# ProtocolOAuth

Protocol settings for authentication using the [OAuth 2.0 Authorization Code flow](https://tools.ietf.org/html/rfc6749#section-4.1)

## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**credentials** | [**OAuthCredentials**](OAuthCredentials.md) |  |  [optional] |
|**endpoints** | [**OAuthEndpoints**](OAuthEndpoints.md) |  |  [optional] |
|**scopes** | **List&lt;String&gt;** | IdP-defined permission bundles to request delegated access from the User &gt; **Note:** The [Identity Provider type](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/createIdentityProvider!path&#x3D;type&amp;t&#x3D;request) table lists the scopes that are supported for each Identity Provider. |  [optional] |
|**type** | [**TypeEnum**](#TypeEnum) | OAuth 2.0 Authorization Code flow |  [optional] |



## Enum: TypeEnum

| Name | Value |
|---- | -----|
| OAUTH2 | &quot;OAUTH2&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |


## Implemented Interfaces

* Serializable


