# OktaApplicationSettingsApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getFirstPartyAppSettings**](OktaApplicationSettingsApi.md#getFirstPartyAppSettings) | **GET** /api/v1/first-party-app-settings/{appName} | Retrieve the Okta Application Settings |
| [**replaceFirstPartyAppSettings**](OktaApplicationSettingsApi.md#replaceFirstPartyAppSettings) | **PUT** /api/v1/first-party-app-settings/{appName} | Replace the Okta Application Settings |



## getFirstPartyAppSettings

> AdminConsoleSettings getFirstPartyAppSettings(appName)

Retrieve the Okta Application Settings

Retrieves the settings for an Okta app (also known as an Okta first-party app)

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.OktaApplicationSettingsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        OktaApplicationSettingsApi apiInstance = new OktaApplicationSettingsApi(defaultClient);
        String appName = "admin-console"; // String | The key name for the Okta app.<br> Supported apps:   * Okta Admin Console (`admin-console`) 
        try {
            AdminConsoleSettings result = apiInstance.getFirstPartyAppSettings(appName);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling OktaApplicationSettingsApi#getFirstPartyAppSettings");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **appName** | **String**| The key name for the Okta app.&lt;br&gt; Supported apps:   * Okta Admin Console (&#x60;admin-console&#x60;)  | |

### Return type

[**AdminConsoleSettings**](AdminConsoleSettings.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## replaceFirstPartyAppSettings

> AdminConsoleSettings replaceFirstPartyAppSettings(appName, adminConsoleSettings)

Replace the Okta Application Settings

Replaces the settings for an Okta app (also known as an Okta first-party app)

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.OktaApplicationSettingsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        OktaApplicationSettingsApi apiInstance = new OktaApplicationSettingsApi(defaultClient);
        String appName = "admin-console"; // String | The key name for the Okta app.<br> Supported apps:   * Okta Admin Console (`admin-console`) 
        AdminConsoleSettings adminConsoleSettings = new AdminConsoleSettings(); // AdminConsoleSettings | 
        try {
            AdminConsoleSettings result = apiInstance.replaceFirstPartyAppSettings(appName, adminConsoleSettings);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling OktaApplicationSettingsApi#replaceFirstPartyAppSettings");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **appName** | **String**| The key name for the Okta app.&lt;br&gt; Supported apps:   * Okta Admin Console (&#x60;admin-console&#x60;)  | |
| **adminConsoleSettings** | [**AdminConsoleSettings**](AdminConsoleSettings.md)|  | |

### Return type

[**AdminConsoleSettings**](AdminConsoleSettings.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |

