# IdentityProviderUsersApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getIdentityProviderApplicationUser**](IdentityProviderUsersApi.md#getIdentityProviderApplicationUser) | **GET** /api/v1/idps/{idpId}/users/{userId} | Retrieve a User for IdP |
| [**linkUserToIdentityProvider**](IdentityProviderUsersApi.md#linkUserToIdentityProvider) | **POST** /api/v1/idps/{idpId}/users/{userId} | Link a User to IdP |
| [**listIdentityProviderApplicationUsers**](IdentityProviderUsersApi.md#listIdentityProviderApplicationUsers) | **GET** /api/v1/idps/{idpId}/users | List all Users for IdP |
| [**listSocialAuthTokens**](IdentityProviderUsersApi.md#listSocialAuthTokens) | **GET** /api/v1/idps/{idpId}/users/{userId}/credentials/tokens | List all Tokens from OIDC IdP |
| [**listUserIdentityProviders**](IdentityProviderUsersApi.md#listUserIdentityProviders) | **GET** /api/v1/users/{userId}/idps | List all Identity Providers for User |
| [**unlinkUserFromIdentityProvider**](IdentityProviderUsersApi.md#unlinkUserFromIdentityProvider) | **DELETE** /api/v1/idps/{idpId}/users/{userId} | Unlink a User from IdP |



## getIdentityProviderApplicationUser

> IdentityProviderApplicationUser getIdentityProviderApplicationUser(idpId, userId)

Retrieve a User for IdP

Retrieves a linked IdP User by ID

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderUsersApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderUsersApi apiInstance = new IdentityProviderUsersApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        try {
            IdentityProviderApplicationUser result = apiInstance.getIdentityProviderApplicationUser(idpId, userId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderUsersApi#getIdentityProviderApplicationUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |
| **userId** | **String**| ID of an existing Okta user | |

### Return type

[**IdentityProviderApplicationUser**](IdentityProviderApplicationUser.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## linkUserToIdentityProvider

> IdentityProviderApplicationUser linkUserToIdentityProvider(idpId, userId, userIdentityProviderLinkRequest)

Link a User to IdP

Links an Okta User to an existing SAML or social Identity Provider.   The SAML Identity Provider must have &#x60;honorPersistentNameId&#x60; set to &#x60;true&#x60; to use this API.  The [Name Identifier Format](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/replaceIdentityProvider!path&#x3D;protocol/0/settings&amp;t&#x3D;request) of the incoming assertion must be &#x60;urn:oasis:names:tc:SAML:2.0:nameid-format:persistent&#x60;.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderUsersApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderUsersApi apiInstance = new IdentityProviderUsersApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        UserIdentityProviderLinkRequest userIdentityProviderLinkRequest = new UserIdentityProviderLinkRequest(); // UserIdentityProviderLinkRequest | 
        try {
            IdentityProviderApplicationUser result = apiInstance.linkUserToIdentityProvider(idpId, userId, userIdentityProviderLinkRequest);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderUsersApi#linkUserToIdentityProvider");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |
| **userId** | **String**| ID of an existing Okta user | |
| **userIdentityProviderLinkRequest** | [**UserIdentityProviderLinkRequest**](UserIdentityProviderLinkRequest.md)|  | |

### Return type

[**IdentityProviderApplicationUser**](IdentityProviderApplicationUser.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listIdentityProviderApplicationUsers

> List&lt;IdentityProviderApplicationUser&gt; listIdentityProviderApplicationUsers(idpId, q, after, limit, expand)

List all Users for IdP

Lists all the Users linked to an Identity Provider

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderUsersApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderUsersApi apiInstance = new IdentityProviderUsersApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        String q = "q_example"; // String | Searches the records for matching value
        String after = "after_example"; // String | The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the `Link` response header. See [Pagination](https://developer.okta.com/docs/api/#pagination).
        Integer limit = 20; // Integer | A limit on the number of objects to return
        String expand = "user"; // String | Expand user data
        try {
            List<IdentityProviderApplicationUser> result = apiInstance.listIdentityProviderApplicationUsers(idpId, q, after, limit, expand);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderUsersApi#listIdentityProviderApplicationUsers");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |
| **q** | **String**| Searches the records for matching value | [optional] |
| **after** | **String**| The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](https://developer.okta.com/docs/api/#pagination). | [optional] |
| **limit** | **Integer**| A limit on the number of objects to return | [optional] [default to 20] |
| **expand** | **String**| Expand user data | [optional] |

### Return type

[**List&lt;IdentityProviderApplicationUser&gt;**](IdentityProviderApplicationUser.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listSocialAuthTokens

> List&lt;SocialAuthToken&gt; listSocialAuthTokens(idpId, userId)

List all Tokens from OIDC IdP

Lists the tokens minted by the Social Authentication Provider when the user authenticates with Okta via Social Auth.  Okta doesn&#39;t import all the User information from a social provider. If the app needs information that isn&#39;t imported, it can get the User token from this endpoint. Then the app can make an API call to the social provider with the token to request the additional information.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderUsersApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderUsersApi apiInstance = new IdentityProviderUsersApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        try {
            List<SocialAuthToken> result = apiInstance.listSocialAuthTokens(idpId, userId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderUsersApi#listSocialAuthTokens");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |
| **userId** | **String**| ID of an existing Okta user | |

### Return type

[**List&lt;SocialAuthToken&gt;**](SocialAuthToken.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listUserIdentityProviders

> List&lt;IdentityProvider&gt; listUserIdentityProviders(userId)

List all Identity Providers for User

Lists the IdPs associated with the User

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderUsersApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderUsersApi apiInstance = new IdentityProviderUsersApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        try {
            List<IdentityProvider> result = apiInstance.listUserIdentityProviders(userId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderUsersApi#listUserIdentityProviders");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |

### Return type

[**List&lt;IdentityProvider&gt;**](IdentityProvider.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## unlinkUserFromIdentityProvider

> unlinkUserFromIdentityProvider(idpId, userId)

Unlink a User from IdP

Unlinks the Okta User and the IdP User. The next time the User federates into Okta through this IdP, they have to re-link their account according to the account link policy.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderUsersApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderUsersApi apiInstance = new IdentityProviderUsersApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        try {
            apiInstance.unlinkUserFromIdentityProvider(idpId, userId);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderUsersApi#unlinkUserFromIdentityProvider");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |
| **userId** | **String**| ID of an existing Okta user | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

