

# IdentityProviderProperties

The properties in the Identity Provider Properties object vary depending on the IdP type

## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**aalValue** | **String** | The [authentication assurance level](https://developers.login.gov/oidc/#aal-values) (AAL) value for the Login.gov IdP.  See [Add a Login.gov IdP](https://developer.okta.com/docs/guides/add-logingov-idp/). Applies to &#x60;LOGINGOV&#x60; and &#x60;LOGINGOV_SANDBOX&#x60; IdP types. |  [optional] |
|**additionalAmr** | [**List&lt;AdditionalAmrEnum&gt;**](#List&lt;AdditionalAmrEnum&gt;) | The additional Assurance Methods References (AMR) values for Smart Card IdPs. Applies to &#x60;X509&#x60; IdP type. |  [optional] |
|**ialValue** | **String** | The [type of identity verification](https://developers.login.gov/oidc/#ial-values) (IAL) value for the Login.gov IdP.  See [Add a Login.gov IdP](https://developer.okta.com/docs/guides/add-logingov-idp/). Applies to &#x60;LOGINGOV&#x60; and &#x60;LOGINGOV_SANDBOX&#x60; IdP types. |  [optional] |



## Enum: List&lt;AdditionalAmrEnum&gt;

| Name | Value |
|---- | -----|
| SC | &quot;sc&quot; |
| HWK | &quot;hwk&quot; |
| PIN | &quot;pin&quot; |
| MFA | &quot;mfa&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |


## Implemented Interfaces

* Serializable


