# IdentityProviderKeysApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createIdentityProviderKey**](IdentityProviderKeysApi.md#createIdentityProviderKey) | **POST** /api/v1/idps/credentials/keys | Create an IdP Key Credential |
| [**deleteIdentityProviderKey**](IdentityProviderKeysApi.md#deleteIdentityProviderKey) | **DELETE** /api/v1/idps/credentials/keys/{kid} | Delete an IdP Key Credential |
| [**getIdentityProviderKey**](IdentityProviderKeysApi.md#getIdentityProviderKey) | **GET** /api/v1/idps/credentials/keys/{kid} | Retrieve an IdP Key Credential |
| [**listIdentityProviderKeys**](IdentityProviderKeysApi.md#listIdentityProviderKeys) | **GET** /api/v1/idps/credentials/keys | List all IdP Key Credentials |
| [**replaceIdentityProviderKey**](IdentityProviderKeysApi.md#replaceIdentityProviderKey) | **PUT** /api/v1/idps/credentials/keys/{kid} | Replace an IdP Key Credential |



## createIdentityProviderKey

> IdPKeyCredential createIdentityProviderKey(jsonWebKey)

Create an IdP Key Credential

Creates a new X.509 certificate credential in the IdP key store &gt; **Note:** RSA-based certificates are supported for all IdP types. Okta currently supports EC-based certificates only for the &#x60;X509&#x60; IdP type. For EC-based certificates we support only P-256, P-384, and P-521 curves.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderKeysApi apiInstance = new IdentityProviderKeysApi(defaultClient);
        IdPCertificateCredential jsonWebKey = new IdPCertificateCredential(); // IdPCertificateCredential | 
        try {
            IdPKeyCredential result = apiInstance.createIdentityProviderKey(jsonWebKey);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderKeysApi#createIdentityProviderKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **jsonWebKey** | [**IdPCertificateCredential**](IdPCertificateCredential.md)|  | |

### Return type

[**IdPKeyCredential**](IdPKeyCredential.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## deleteIdentityProviderKey

> deleteIdentityProviderKey(kid)

Delete an IdP Key Credential

Deletes a specific IdP Key Credential by &#x60;kid&#x60; if it isn&#39;t currently being used by an active or inactive IdP

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderKeysApi apiInstance = new IdentityProviderKeysApi(defaultClient);
        String kid = "KmMo85SSsU7TZzOShcGb"; // String | Unique `id` of the IdP Key Credential
        try {
            apiInstance.deleteIdentityProviderKey(kid);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderKeysApi#deleteIdentityProviderKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **kid** | **String**| Unique &#x60;id&#x60; of the IdP Key Credential | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getIdentityProviderKey

> IdPKeyCredential getIdentityProviderKey(kid)

Retrieve an IdP Key Credential

Retrieves a specific IdP Key Credential by &#x60;kid&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderKeysApi apiInstance = new IdentityProviderKeysApi(defaultClient);
        String kid = "KmMo85SSsU7TZzOShcGb"; // String | Unique `id` of the IdP Key Credential
        try {
            IdPKeyCredential result = apiInstance.getIdentityProviderKey(kid);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderKeysApi#getIdentityProviderKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **kid** | **String**| Unique &#x60;id&#x60; of the IdP Key Credential | |

### Return type

[**IdPKeyCredential**](IdPKeyCredential.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listIdentityProviderKeys

> List&lt;IdPKeyCredential&gt; listIdentityProviderKeys(after, limit)

List all IdP Key Credentials

Lists all IdP Key Credentials

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderKeysApi apiInstance = new IdentityProviderKeysApi(defaultClient);
        String after = "after_example"; // String | The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the `Link` response header. See [Pagination](https://developer.okta.com/docs/api/#pagination).
        Integer limit = 20; // Integer | A limit on the number of objects to return
        try {
            List<IdPKeyCredential> result = apiInstance.listIdentityProviderKeys(after, limit);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderKeysApi#listIdentityProviderKeys");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **after** | **String**| The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](https://developer.okta.com/docs/api/#pagination). | [optional] |
| **limit** | **Integer**| A limit on the number of objects to return | [optional] [default to 20] |

### Return type

[**List&lt;IdPKeyCredential&gt;**](IdPKeyCredential.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## replaceIdentityProviderKey

> IdPKeyCredential replaceIdentityProviderKey(kid, idPKeyCredential)

Replace an IdP Key Credential

Replaces an IdP Key Credential by &#x60;kid&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderKeysApi apiInstance = new IdentityProviderKeysApi(defaultClient);
        String kid = "KmMo85SSsU7TZzOShcGb"; // String | Unique `id` of the IdP Key Credential
        IdPKeyCredential idPKeyCredential = new IdPKeyCredential(); // IdPKeyCredential | Updated IdP Key Credential
        try {
            IdPKeyCredential result = apiInstance.replaceIdentityProviderKey(kid, idPKeyCredential);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderKeysApi#replaceIdentityProviderKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **kid** | **String**| Unique &#x60;id&#x60; of the IdP Key Credential | |
| **idPKeyCredential** | [**IdPKeyCredential**](IdPKeyCredential.md)| Updated IdP Key Credential | |

### Return type

[**IdPKeyCredential**](IdPKeyCredential.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

