# FeatureApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getFeature**](FeatureApi.md#getFeature) | **GET** /api/v1/features/{featureId} | Retrieve a Feature |
| [**listFeatureDependencies**](FeatureApi.md#listFeatureDependencies) | **GET** /api/v1/features/{featureId}/dependencies | List all dependencies |
| [**listFeatureDependents**](FeatureApi.md#listFeatureDependents) | **GET** /api/v1/features/{featureId}/dependents | List all dependents |
| [**listFeatures**](FeatureApi.md#listFeatures) | **GET** /api/v1/features | List all Features |
| [**updateFeatureLifecycle**](FeatureApi.md#updateFeatureLifecycle) | **POST** /api/v1/features/{featureId}/{lifecycle} | Update a Feature lifecycle |



## getFeature

> Feature getFeature(featureId)

Retrieve a Feature

Retrieves a feature by ID

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.FeatureApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        FeatureApi apiInstance = new FeatureApi(defaultClient);
        String featureId = "R5HjqNn1pEqWGy48E9jg"; // String | `id` of the feature
        try {
            Feature result = apiInstance.getFeature(featureId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling FeatureApi#getFeature");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **featureId** | **String**| &#x60;id&#x60; of the feature | |

### Return type

[**Feature**](Feature.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listFeatureDependencies

> List&lt;Feature&gt; listFeatureDependencies(featureId)

List all dependencies

Lists all feature dependencies for a specified feature.  A feature&#39;s dependencies are the features that it requires to be enabled in order for itself to be enabled.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.FeatureApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        FeatureApi apiInstance = new FeatureApi(defaultClient);
        String featureId = "R5HjqNn1pEqWGy48E9jg"; // String | `id` of the feature
        try {
            List<Feature> result = apiInstance.listFeatureDependencies(featureId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling FeatureApi#listFeatureDependencies");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **featureId** | **String**| &#x60;id&#x60; of the feature | |

### Return type

[**List&lt;Feature&gt;**](Feature.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listFeatureDependents

> List&lt;Feature&gt; listFeatureDependents(featureId)

List all dependents

Lists all feature dependents for the specified feature.  A feature&#39;s dependents are the features that need to be disabled in order for the feature itself to be disabled.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.FeatureApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        FeatureApi apiInstance = new FeatureApi(defaultClient);
        String featureId = "R5HjqNn1pEqWGy48E9jg"; // String | `id` of the feature
        try {
            List<Feature> result = apiInstance.listFeatureDependents(featureId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling FeatureApi#listFeatureDependents");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **featureId** | **String**| &#x60;id&#x60; of the feature | |

### Return type

[**List&lt;Feature&gt;**](Feature.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listFeatures

> List&lt;Feature&gt; listFeatures()

List all Features

Lists all self-service features for your org

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.FeatureApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        FeatureApi apiInstance = new FeatureApi(defaultClient);
        try {
            List<Feature> result = apiInstance.listFeatures();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling FeatureApi#listFeatures");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**List&lt;Feature&gt;**](Feature.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## updateFeatureLifecycle

> Feature updateFeatureLifecycle(featureId, lifecycle, mode)

Update a Feature lifecycle

Updates a feature&#39;s lifecycle status. Use this endpoint to enable or disable a feature for your org.  Use the &#x60;mode&#x3D;force&#x60; parameter to override dependency restrictions for a particular feature. Normally, you can&#39;t enable a feature if it has one or more dependencies that aren&#39;t enabled.  When you use the &#x60;mode&#x3D;force&#x60; parameter while enabling a feature, Okta first tries to enable any disabled features that this feature may have as dependencies. If you don&#39;t pass the &#x60;mode&#x3D;force&#x60; parameter and the feature has dependencies that need to be enabled before the feature is enabled, a 400 error is returned.  When you use the &#x60;mode&#x3D;force&#x60; parameter while disabling a feature, Okta first tries to disable any enabled features that this feature may have as dependents. If you don&#39;t pass the &#x60;mode&#x3D;force&#x60; parameter and the feature has dependents that need to be disabled before the feature is disabled, a 400 error is returned.  The following chart shows the different state transitions for a feature.  ![State transitions of a feature](../../../../../images/features/update-ssfeat-flowchart.png &#39;#width&#x3D;500px;&#39;)

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.FeatureApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        FeatureApi apiInstance = new FeatureApi(defaultClient);
        String featureId = "R5HjqNn1pEqWGy48E9jg"; // String | `id` of the feature
        FeatureLifecycle lifecycle = FeatureLifecycle.fromValue("DISABLE"); // FeatureLifecycle | Whether to `ENABLE` or `DISABLE` the feature
        String mode = "mode_example"; // String | Indicates if you want to force enable or disable a feature. Supported value is `force`.
        try {
            Feature result = apiInstance.updateFeatureLifecycle(featureId, lifecycle, mode);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling FeatureApi#updateFeatureLifecycle");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **featureId** | **String**| &#x60;id&#x60; of the feature | |
| **lifecycle** | [**FeatureLifecycle**](.md)| Whether to &#x60;ENABLE&#x60; or &#x60;DISABLE&#x60; the feature | [enum: DISABLE, ENABLE] |
| **mode** | **String**| Indicates if you want to force enable or disable a feature. Supported value is &#x60;force&#x60;. | [optional] |

### Return type

[**Feature**](Feature.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

