# EmailDomainApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createEmailDomain**](EmailDomainApi.md#createEmailDomain) | **POST** /api/v1/email-domains | Create an Email Domain |
| [**deleteEmailDomain**](EmailDomainApi.md#deleteEmailDomain) | **DELETE** /api/v1/email-domains/{emailDomainId} | Delete an Email Domain |
| [**getEmailDomain**](EmailDomainApi.md#getEmailDomain) | **GET** /api/v1/email-domains/{emailDomainId} | Retrieve an Email Domain |
| [**listEmailDomains**](EmailDomainApi.md#listEmailDomains) | **GET** /api/v1/email-domains | List all Email Domains |
| [**replaceEmailDomain**](EmailDomainApi.md#replaceEmailDomain) | **PUT** /api/v1/email-domains/{emailDomainId} | Replace an Email Domain |
| [**verifyEmailDomain**](EmailDomainApi.md#verifyEmailDomain) | **POST** /api/v1/email-domains/{emailDomainId}/verify | Verify an Email Domain |



## createEmailDomain

> EmailDomainResponse createEmailDomain(emailDomain, expand)

Create an Email Domain

Creates an Email Domain in your org

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EmailDomainApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EmailDomainApi apiInstance = new EmailDomainApi(defaultClient);
        EmailDomain emailDomain = new EmailDomain(); // EmailDomain | 
        List<String> expand = Arrays.asList(); // List<String> | Specifies additional metadata to be included in the response
        try {
            EmailDomainResponse result = apiInstance.createEmailDomain(emailDomain, expand);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling EmailDomainApi#createEmailDomain");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **emailDomain** | [**EmailDomain**](EmailDomain.md)|  | |
| **expand** | [**List&lt;String&gt;**](String.md)| Specifies additional metadata to be included in the response | [optional] [enum: brands] |

### Return type

[**EmailDomainResponse**](EmailDomainResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **409** | Conflict |  -  |
| **429** | Too Many Requests |  -  |


## deleteEmailDomain

> deleteEmailDomain(emailDomainId, expand)

Delete an Email Domain

Deletes an Email Domain by &#x60;emailDomainId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EmailDomainApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EmailDomainApi apiInstance = new EmailDomainApi(defaultClient);
        String emailDomainId = "emailDomainId_example"; // String | 
        List<String> expand = Arrays.asList(); // List<String> | Specifies additional metadata to be included in the response
        try {
            apiInstance.deleteEmailDomain(emailDomainId, expand);
        } catch (ApiException e) {
            System.err.println("Exception when calling EmailDomainApi#deleteEmailDomain");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **emailDomainId** | **String**|  | |
| **expand** | [**List&lt;String&gt;**](String.md)| Specifies additional metadata to be included in the response | [optional] [enum: brands] |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **400** | Unable to delete custom email domain due to mail provider specific restrictions |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getEmailDomain

> EmailDomainResponseWithEmbedded getEmailDomain(emailDomainId, expand)

Retrieve an Email Domain

Retrieves an Email Domain by &#x60;emailDomainId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EmailDomainApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EmailDomainApi apiInstance = new EmailDomainApi(defaultClient);
        String emailDomainId = "emailDomainId_example"; // String | 
        List<String> expand = Arrays.asList(); // List<String> | Specifies additional metadata to be included in the response
        try {
            EmailDomainResponseWithEmbedded result = apiInstance.getEmailDomain(emailDomainId, expand);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling EmailDomainApi#getEmailDomain");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **emailDomainId** | **String**|  | |
| **expand** | [**List&lt;String&gt;**](String.md)| Specifies additional metadata to be included in the response | [optional] [enum: brands] |

### Return type

[**EmailDomainResponseWithEmbedded**](EmailDomainResponseWithEmbedded.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listEmailDomains

> List&lt;EmailDomainResponseWithEmbedded&gt; listEmailDomains(expand)

List all Email Domains

Lists all the Email Domains in your org

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EmailDomainApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EmailDomainApi apiInstance = new EmailDomainApi(defaultClient);
        List<String> expand = Arrays.asList(); // List<String> | Specifies additional metadata to be included in the response
        try {
            List<EmailDomainResponseWithEmbedded> result = apiInstance.listEmailDomains(expand);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling EmailDomainApi#listEmailDomains");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **expand** | [**List&lt;String&gt;**](String.md)| Specifies additional metadata to be included in the response | [optional] [enum: brands] |

### Return type

[**List&lt;EmailDomainResponseWithEmbedded&gt;**](EmailDomainResponseWithEmbedded.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## replaceEmailDomain

> EmailDomainResponse replaceEmailDomain(emailDomainId, updateEmailDomain, expand)

Replace an Email Domain

Replaces associated username and sender display name by &#x60;emailDomainId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EmailDomainApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EmailDomainApi apiInstance = new EmailDomainApi(defaultClient);
        String emailDomainId = "emailDomainId_example"; // String | 
        UpdateEmailDomain updateEmailDomain = new UpdateEmailDomain(); // UpdateEmailDomain | 
        List<String> expand = Arrays.asList(); // List<String> | Specifies additional metadata to be included in the response
        try {
            EmailDomainResponse result = apiInstance.replaceEmailDomain(emailDomainId, updateEmailDomain, expand);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling EmailDomainApi#replaceEmailDomain");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **emailDomainId** | **String**|  | |
| **updateEmailDomain** | [**UpdateEmailDomain**](UpdateEmailDomain.md)|  | |
| **expand** | [**List&lt;String&gt;**](String.md)| Specifies additional metadata to be included in the response | [optional] [enum: brands] |

### Return type

[**EmailDomainResponse**](EmailDomainResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## verifyEmailDomain

> EmailDomainResponse verifyEmailDomain(emailDomainId)

Verify an Email Domain

Verifies an Email Domain by &#x60;emailDomainId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EmailDomainApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EmailDomainApi apiInstance = new EmailDomainApi(defaultClient);
        String emailDomainId = "emailDomainId_example"; // String | 
        try {
            EmailDomainResponse result = apiInstance.verifyEmailDomain(emailDomainId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling EmailDomainApi#verifyEmailDomain");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **emailDomainId** | **String**|  | |

### Return type

[**EmailDomainResponse**](EmailDomainResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Email domain could not be verified by mail provider |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

