# DeviceAssuranceApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createDeviceAssurancePolicy**](DeviceAssuranceApi.md#createDeviceAssurancePolicy) | **POST** /api/v1/device-assurances | Create a Device Assurance Policy |
| [**deleteDeviceAssurancePolicy**](DeviceAssuranceApi.md#deleteDeviceAssurancePolicy) | **DELETE** /api/v1/device-assurances/{deviceAssuranceId} | Delete a Device Assurance Policy |
| [**getDeviceAssurancePolicy**](DeviceAssuranceApi.md#getDeviceAssurancePolicy) | **GET** /api/v1/device-assurances/{deviceAssuranceId} | Retrieve a Device Assurance Policy |
| [**listDeviceAssurancePolicies**](DeviceAssuranceApi.md#listDeviceAssurancePolicies) | **GET** /api/v1/device-assurances | List all Device Assurance Policies |
| [**replaceDeviceAssurancePolicy**](DeviceAssuranceApi.md#replaceDeviceAssurancePolicy) | **PUT** /api/v1/device-assurances/{deviceAssuranceId} | Replace a Device Assurance Policy |



## createDeviceAssurancePolicy

> DeviceAssurance createDeviceAssurancePolicy(deviceAssurance)

Create a Device Assurance Policy

Creates a new Device Assurance Policy

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.DeviceAssuranceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        DeviceAssuranceApi apiInstance = new DeviceAssuranceApi(defaultClient);
        DeviceAssurance deviceAssurance = new DeviceAssurance(); // DeviceAssurance | 
        try {
            DeviceAssurance result = apiInstance.createDeviceAssurancePolicy(deviceAssurance);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling DeviceAssuranceApi#createDeviceAssurancePolicy");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **deviceAssurance** | [**DeviceAssurance**](DeviceAssurance.md)|  | |

### Return type

[**DeviceAssurance**](DeviceAssurance.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## deleteDeviceAssurancePolicy

> deleteDeviceAssurancePolicy(deviceAssuranceId)

Delete a Device Assurance Policy

Deletes a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;. If the Device Assurance Policy is currently being used in the org Authentication Policies, the delete will not be allowed.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.DeviceAssuranceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        DeviceAssuranceApi apiInstance = new DeviceAssuranceApi(defaultClient);
        String deviceAssuranceId = "deviceAssuranceId_example"; // String | Id of the Device Assurance Policy
        try {
            apiInstance.deleteDeviceAssurancePolicy(deviceAssuranceId);
        } catch (ApiException e) {
            System.err.println("Exception when calling DeviceAssuranceApi#deleteDeviceAssurancePolicy");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **deviceAssuranceId** | **String**| Id of the Device Assurance Policy | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **409** | Conflict |  -  |
| **429** | Too Many Requests |  -  |


## getDeviceAssurancePolicy

> DeviceAssurance getDeviceAssurancePolicy(deviceAssuranceId)

Retrieve a Device Assurance Policy

Retrieves a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.DeviceAssuranceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        DeviceAssuranceApi apiInstance = new DeviceAssuranceApi(defaultClient);
        String deviceAssuranceId = "deviceAssuranceId_example"; // String | Id of the Device Assurance Policy
        try {
            DeviceAssurance result = apiInstance.getDeviceAssurancePolicy(deviceAssuranceId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling DeviceAssuranceApi#getDeviceAssurancePolicy");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **deviceAssuranceId** | **String**| Id of the Device Assurance Policy | |

### Return type

[**DeviceAssurance**](DeviceAssurance.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listDeviceAssurancePolicies

> List&lt;DeviceAssurance&gt; listDeviceAssurancePolicies()

List all Device Assurance Policies

Lists all device assurance policies

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.DeviceAssuranceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        DeviceAssuranceApi apiInstance = new DeviceAssuranceApi(defaultClient);
        try {
            List<DeviceAssurance> result = apiInstance.listDeviceAssurancePolicies();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling DeviceAssuranceApi#listDeviceAssurancePolicies");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**List&lt;DeviceAssurance&gt;**](DeviceAssurance.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## replaceDeviceAssurancePolicy

> DeviceAssurance replaceDeviceAssurancePolicy(deviceAssuranceId, deviceAssurance)

Replace a Device Assurance Policy

Replaces a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.DeviceAssuranceApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        DeviceAssuranceApi apiInstance = new DeviceAssuranceApi(defaultClient);
        String deviceAssuranceId = "deviceAssuranceId_example"; // String | Id of the Device Assurance Policy
        DeviceAssurance deviceAssurance = new DeviceAssurance(); // DeviceAssurance | 
        try {
            DeviceAssurance result = apiInstance.replaceDeviceAssurancePolicy(deviceAssuranceId, deviceAssurance);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling DeviceAssuranceApi#replaceDeviceAssurancePolicy");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **deviceAssuranceId** | **String**| Id of the Device Assurance Policy | |
| **deviceAssurance** | [**DeviceAssurance**](DeviceAssurance.md)|  | |

### Return type

[**DeviceAssurance**](DeviceAssurance.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

