

# ChildOrg


## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**admin** | [**OrgCreationAdmin**](OrgCreationAdmin.md) |  |  |
|**created** | **OffsetDateTime** | Timestamp when the Org was created |  [optional] [readonly] |
|**edition** | [**EditionEnum**](#EditionEnum) | Edition for the Org. &#x60;SKU&#x60; is the only supported value. |  |
|**id** | **String** | Org ID |  [optional] [readonly] |
|**lastUpdated** | **OffsetDateTime** | Timestamp when the Org was last updated |  [optional] [readonly] |
|**name** | **String** | Unique name of the Org. This name appears in the HTML &#x60;&lt;title&gt;&#x60; tag of the new Org sign-in page. Only less than 4-width UTF-8 encoded characters are allowed. |  |
|**settings** | **Map&lt;String, Object&gt;** | Settings associated with the created Org |  [optional] [readonly] |
|**status** | [**StatusEnum**](#StatusEnum) | Status of the Org. &#x60;ACTIVE&#x60; is returned after the Org is created. |  [optional] [readonly] |
|**subdomain** | **String** | Subdomain of the Org. Must be unique and include no spaces. |  |
|**token** | **String** | API token associated with the child Org super admin account. Use this API token to provision resources (such as policies, apps, and groups) on the newly created child Org. This token is revoked if the super admin account is deactivated. &gt; **Note:** If this API token expires, sign in to the Admin Console as the super admin user and create a new API token. See [Create an API token](https://developer.okta.com/docs/guides/create-an-api-token/). |  [optional] [readonly] |
|**tokenType** | [**TokenTypeEnum**](#TokenTypeEnum) | Type of returned &#x60;token&#x60;. See [Okta API tokens](https://developer.okta.com/docs/guides/create-an-api-token/main/#okta-api-tokens). |  [optional] [readonly] |
|**website** | **String** | Default website for the Org |  [optional] |
|**links** | **Map&lt;String, Object&gt;** | Specifies available link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification |  [optional] [readonly] |



## Enum: EditionEnum

| Name | Value |
|---- | -----|
| SKU | &quot;SKU&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |



## Enum: StatusEnum

| Name | Value |
|---- | -----|
| ACTIVE | &quot;ACTIVE&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |



## Enum: TokenTypeEnum

| Name | Value |
|---- | -----|
| SSWS | &quot;SSWS&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |


## Implemented Interfaces

* Serializable


