# AuthorizationServerKeysApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getAuthorizationServerKey**](AuthorizationServerKeysApi.md#getAuthorizationServerKey) | **GET** /api/v1/authorizationServers/{authServerId}/credentials/keys/{keyId} | Retrieve an Authorization Server Key |
| [**listAuthorizationServerKeys**](AuthorizationServerKeysApi.md#listAuthorizationServerKeys) | **GET** /api/v1/authorizationServers/{authServerId}/credentials/keys | List all Credential Keys |
| [**rotateAuthorizationServerKeys**](AuthorizationServerKeysApi.md#rotateAuthorizationServerKeys) | **POST** /api/v1/authorizationServers/{authServerId}/credentials/lifecycle/keyRotate | Rotate all Credential Keys |



## getAuthorizationServerKey

> AuthorizationServerJsonWebKey getAuthorizationServerKey(authServerId, keyId)

Retrieve an Authorization Server Key

Retrieves an Authorization Server Key specified by the &#x60;keyId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerKeysApi apiInstance = new AuthorizationServerKeysApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String keyId = "P7jXpG-LG2ObNgY9C0Mn2uf4InCQTmRZMDCZoVNxdrk"; // String | `id` of the certificate key
        try {
            AuthorizationServerJsonWebKey result = apiInstance.getAuthorizationServerKey(authServerId, keyId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerKeysApi#getAuthorizationServerKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **keyId** | **String**| &#x60;id&#x60; of the certificate key | |

### Return type

[**AuthorizationServerJsonWebKey**](AuthorizationServerJsonWebKey.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listAuthorizationServerKeys

> List&lt;AuthorizationServerJsonWebKey&gt; listAuthorizationServerKeys(authServerId)

List all Credential Keys

Lists all of the current, future, and expired Keys used by the Custom Authorization Server

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerKeysApi apiInstance = new AuthorizationServerKeysApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        try {
            List<AuthorizationServerJsonWebKey> result = apiInstance.listAuthorizationServerKeys(authServerId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerKeysApi#listAuthorizationServerKeys");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |

### Return type

[**List&lt;AuthorizationServerJsonWebKey&gt;**](AuthorizationServerJsonWebKey.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## rotateAuthorizationServerKeys

> List&lt;AuthorizationServerJsonWebKey&gt; rotateAuthorizationServerKeys(authServerId, use)

Rotate all Credential Keys

Rotates the current Keys for a Custom Authorization Server. If you rotate Keys,  the &#x60;ACTIVE&#x60; Key becomes the &#x60;EXPIRED&#x60; Key, the &#x60;NEXT&#x60; Key becomes the &#x60;ACTIVE&#x60; Key,  and the Custom Authorization Server immediately begins using the new active  Key to sign tokens.  &gt; **Note:** Okta rotates your Keys automatically in &#x60;AUTO&#x60; mode. You can rotate Keys  yourself in either mode. If Keys are rotated manually, you should invalidate any intermediate cache  and fetch the Keys again using the Keys endpoint.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerKeysApi apiInstance = new AuthorizationServerKeysApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        JwkUse use = new JwkUse(); // JwkUse | 
        try {
            List<AuthorizationServerJsonWebKey> result = apiInstance.rotateAuthorizationServerKeys(authServerId, use);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerKeysApi#rotateAuthorizationServerKeys");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **use** | [**JwkUse**](JwkUse.md)|  | |

### Return type

[**List&lt;AuthorizationServerJsonWebKey&gt;**](AuthorizationServerJsonWebKey.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

