package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserIdentifierConditionEvaluatorPattern;
import com.okta.sdk.resource.model.UserIdentifierType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies a user identifier condition to match on
 */
@ApiModel(description = "Specifies a user identifier condition to match on")
@JsonPropertyOrder({ UserIdentifierPolicyRuleCondition.JSON_PROPERTY_ATTRIBUTE,
        UserIdentifierPolicyRuleCondition.JSON_PROPERTY_PATTERNS,
        UserIdentifierPolicyRuleCondition.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserIdentifierPolicyRuleCondition implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ATTRIBUTE = "attribute";
    private String attribute;

    public static final String JSON_PROPERTY_PATTERNS = "patterns";
    private List<UserIdentifierConditionEvaluatorPattern> patterns = new ArrayList<>();

    public static final String JSON_PROPERTY_TYPE = "type";
    private UserIdentifierType type;

    public UserIdentifierPolicyRuleCondition() {
    }

    public UserIdentifierPolicyRuleCondition attribute(String attribute) {

        this.attribute = attribute;
        return this;
    }

    /**
     * The name of the profile attribute to match against. Only used when type is &#x60;ATTRIBUTE&#x60;.
     *
     * @return attribute
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The name of the profile attribute to match against. Only used when type is `ATTRIBUTE`.")
    @JsonProperty(JSON_PROPERTY_ATTRIBUTE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAttribute() {
        return attribute;
    }

    @JsonProperty(JSON_PROPERTY_ATTRIBUTE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public UserIdentifierPolicyRuleCondition patterns(List<UserIdentifierConditionEvaluatorPattern> patterns) {

        this.patterns = patterns;
        return this;
    }

    public UserIdentifierPolicyRuleCondition addpatternsItem(UserIdentifierConditionEvaluatorPattern patternsItem) {
        if (this.patterns == null) {
            this.patterns = new ArrayList<>();
        }
        this.patterns.add(patternsItem);
        return this;
    }

    /**
     * Get patterns
     *
     * @return patterns
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_PATTERNS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public List<UserIdentifierConditionEvaluatorPattern> getPatterns() {
        return patterns;
    }

    @JsonProperty(JSON_PROPERTY_PATTERNS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setPatterns(List<UserIdentifierConditionEvaluatorPattern> patterns) {
        this.patterns = patterns;
    }

    public UserIdentifierPolicyRuleCondition type(UserIdentifierType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public UserIdentifierType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setType(UserIdentifierType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserIdentifierPolicyRuleCondition userIdentifierPolicyRuleCondition = (UserIdentifierPolicyRuleCondition) o;
        return Objects.equals(this.attribute, userIdentifierPolicyRuleCondition.attribute)
                && Objects.equals(this.patterns, userIdentifierPolicyRuleCondition.patterns)
                && Objects.equals(this.type, userIdentifierPolicyRuleCondition.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(attribute, patterns, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserIdentifierPolicyRuleCondition {\n");
        sb.append("    attribute: ").append(toIndentedString(attribute)).append("\n");
        sb.append("    patterns: ").append(toIndentedString(patterns)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
