package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserFactorLinks;
import com.okta.sdk.resource.model.UserFactorVerifyResult;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactorVerifyResponse
 */
@JsonPropertyOrder({ UserFactorVerifyResponse.JSON_PROPERTY_EXPIRES_AT,
        UserFactorVerifyResponse.JSON_PROPERTY_FACTOR_MESSAGE, UserFactorVerifyResponse.JSON_PROPERTY_FACTOR_RESULT,
        UserFactorVerifyResponse.JSON_PROPERTY_EMBEDDED, UserFactorVerifyResponse.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserFactorVerifyResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;

    public static final String JSON_PROPERTY_FACTOR_MESSAGE = "factorMessage";
    private JsonNullable<String> factorMessage = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_FACTOR_RESULT = "factorResult";
    private UserFactorVerifyResult factorResult;

    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Map<String, Object> embedded = null;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private UserFactorLinks links;

    public UserFactorVerifyResponse() {
    }

    /*
     * @JsonCreator public UserFactorVerifyResponse(
     *
     * @JsonProperty(JSON_PROPERTY_EXPIRES_AT) OffsetDateTime expiresAt,
     *
     * @JsonProperty(JSON_PROPERTY_FACTOR_MESSAGE) String factorMessage,
     *
     * @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded ) { this(); this.expiresAt = expiresAt;
     * this.factorMessage = factorMessage; this.embedded = embedded; }
     */

    /**
     * Timestamp when the verification expires
     *
     * @return expiresAt
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2022-08-25T00:31Z", value = "Timestamp when the verification expires")
    @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getExpiresAt() {
        return expiresAt;
    }

    /**
     * Optional display message for Factor verification
     *
     * @return factorMessage
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Optional display message for Factor verification")
    @JsonIgnore

    public String getFactorMessage() {

        if (factorMessage == null) {
            factorMessage = JsonNullable.<String> undefined();
        }
        return factorMessage.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_FACTOR_MESSAGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getFactorMessage_JsonNullable() {
        return factorMessage;
    }

    @JsonProperty(JSON_PROPERTY_FACTOR_MESSAGE)
    private void setFactorMessage_JsonNullable(JsonNullable<String> factorMessage) {
        this.factorMessage = factorMessage;
    }

    public UserFactorVerifyResponse factorResult(UserFactorVerifyResult factorResult) {

        this.factorResult = factorResult;
        return this;
    }

    /**
     * Get factorResult
     *
     * @return factorResult
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_FACTOR_RESULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorVerifyResult getFactorResult() {
        return factorResult;
    }

    @JsonProperty(JSON_PROPERTY_FACTOR_RESULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFactorResult(UserFactorVerifyResult factorResult) {
        this.factorResult = factorResult;
    }

    /**
     * Get embedded
     *
     * @return embedded
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getEmbedded() {
        return embedded;
    }

    public UserFactorVerifyResponse links(UserFactorLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(UserFactorLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorVerifyResponse userFactorVerifyResponse = (UserFactorVerifyResponse) o;
        return Objects.equals(this.expiresAt, userFactorVerifyResponse.expiresAt)
                && equalsNullable(this.factorMessage, userFactorVerifyResponse.factorMessage)
                && Objects.equals(this.factorResult, userFactorVerifyResponse.factorResult)
                && Objects.equals(this.embedded, userFactorVerifyResponse.embedded)
                && Objects.equals(this.links, userFactorVerifyResponse.links);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(expiresAt, hashCodeNullable(factorMessage), factorResult, embedded, links);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorVerifyResponse {\n");
        sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
        sb.append("    factorMessage: ").append(toIndentedString(factorMessage)).append("\n");
        sb.append("    factorResult: ").append(toIndentedString(factorResult)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
