package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EmailTemplateTouchPointVariant;
import com.okta.sdk.resource.model.EndUserDashboardTouchPointVariant;
import com.okta.sdk.resource.model.ErrorPageTouchPointVariant;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.LoadingPageTouchPointVariant;
import com.okta.sdk.resource.model.SignInPageTouchPointVariant;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UpdateThemeRequest
 */
@JsonPropertyOrder({ UpdateThemeRequest.JSON_PROPERTY_EMAIL_TEMPLATE_TOUCH_POINT_VARIANT,
        UpdateThemeRequest.JSON_PROPERTY_END_USER_DASHBOARD_TOUCH_POINT_VARIANT,
        UpdateThemeRequest.JSON_PROPERTY_ERROR_PAGE_TOUCH_POINT_VARIANT,
        UpdateThemeRequest.JSON_PROPERTY_LOADING_PAGE_TOUCH_POINT_VARIANT,
        UpdateThemeRequest.JSON_PROPERTY_PRIMARY_COLOR_CONTRAST_HEX, UpdateThemeRequest.JSON_PROPERTY_PRIMARY_COLOR_HEX,
        UpdateThemeRequest.JSON_PROPERTY_SECONDARY_COLOR_CONTRAST_HEX,
        UpdateThemeRequest.JSON_PROPERTY_SECONDARY_COLOR_HEX,
        UpdateThemeRequest.JSON_PROPERTY_SIGN_IN_PAGE_TOUCH_POINT_VARIANT, UpdateThemeRequest.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UpdateThemeRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EMAIL_TEMPLATE_TOUCH_POINT_VARIANT = "emailTemplateTouchPointVariant";
    private EmailTemplateTouchPointVariant emailTemplateTouchPointVariant = EmailTemplateTouchPointVariant.OKTA_DEFAULT;

    public static final String JSON_PROPERTY_END_USER_DASHBOARD_TOUCH_POINT_VARIANT = "endUserDashboardTouchPointVariant";
    private EndUserDashboardTouchPointVariant endUserDashboardTouchPointVariant = EndUserDashboardTouchPointVariant.OKTA_DEFAULT;

    public static final String JSON_PROPERTY_ERROR_PAGE_TOUCH_POINT_VARIANT = "errorPageTouchPointVariant";
    private ErrorPageTouchPointVariant errorPageTouchPointVariant = ErrorPageTouchPointVariant.OKTA_DEFAULT;

    public static final String JSON_PROPERTY_LOADING_PAGE_TOUCH_POINT_VARIANT = "loadingPageTouchPointVariant";
    private LoadingPageTouchPointVariant loadingPageTouchPointVariant = LoadingPageTouchPointVariant.OKTA_DEFAULT;

    public static final String JSON_PROPERTY_PRIMARY_COLOR_CONTRAST_HEX = "primaryColorContrastHex";
    private String primaryColorContrastHex;

    public static final String JSON_PROPERTY_PRIMARY_COLOR_HEX = "primaryColorHex";
    private String primaryColorHex;

    public static final String JSON_PROPERTY_SECONDARY_COLOR_CONTRAST_HEX = "secondaryColorContrastHex";
    private String secondaryColorContrastHex;

    public static final String JSON_PROPERTY_SECONDARY_COLOR_HEX = "secondaryColorHex";
    private String secondaryColorHex;

    public static final String JSON_PROPERTY_SIGN_IN_PAGE_TOUCH_POINT_VARIANT = "signInPageTouchPointVariant";
    private SignInPageTouchPointVariant signInPageTouchPointVariant;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public UpdateThemeRequest() {
    }

    public UpdateThemeRequest emailTemplateTouchPointVariant(
            EmailTemplateTouchPointVariant emailTemplateTouchPointVariant) {

        this.emailTemplateTouchPointVariant = emailTemplateTouchPointVariant;
        return this;
    }

    /**
     * Get emailTemplateTouchPointVariant
     *
     * @return emailTemplateTouchPointVariant
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_EMAIL_TEMPLATE_TOUCH_POINT_VARIANT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public EmailTemplateTouchPointVariant getEmailTemplateTouchPointVariant() {
        return emailTemplateTouchPointVariant;
    }

    @JsonProperty(JSON_PROPERTY_EMAIL_TEMPLATE_TOUCH_POINT_VARIANT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEmailTemplateTouchPointVariant(EmailTemplateTouchPointVariant emailTemplateTouchPointVariant) {
        this.emailTemplateTouchPointVariant = emailTemplateTouchPointVariant;
    }

    public UpdateThemeRequest endUserDashboardTouchPointVariant(
            EndUserDashboardTouchPointVariant endUserDashboardTouchPointVariant) {

        this.endUserDashboardTouchPointVariant = endUserDashboardTouchPointVariant;
        return this;
    }

    /**
     * Get endUserDashboardTouchPointVariant
     *
     * @return endUserDashboardTouchPointVariant
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_END_USER_DASHBOARD_TOUCH_POINT_VARIANT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public EndUserDashboardTouchPointVariant getEndUserDashboardTouchPointVariant() {
        return endUserDashboardTouchPointVariant;
    }

    @JsonProperty(JSON_PROPERTY_END_USER_DASHBOARD_TOUCH_POINT_VARIANT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEndUserDashboardTouchPointVariant(
            EndUserDashboardTouchPointVariant endUserDashboardTouchPointVariant) {
        this.endUserDashboardTouchPointVariant = endUserDashboardTouchPointVariant;
    }

    public UpdateThemeRequest errorPageTouchPointVariant(ErrorPageTouchPointVariant errorPageTouchPointVariant) {

        this.errorPageTouchPointVariant = errorPageTouchPointVariant;
        return this;
    }

    /**
     * Get errorPageTouchPointVariant
     *
     * @return errorPageTouchPointVariant
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_ERROR_PAGE_TOUCH_POINT_VARIANT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public ErrorPageTouchPointVariant getErrorPageTouchPointVariant() {
        return errorPageTouchPointVariant;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_PAGE_TOUCH_POINT_VARIANT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setErrorPageTouchPointVariant(ErrorPageTouchPointVariant errorPageTouchPointVariant) {
        this.errorPageTouchPointVariant = errorPageTouchPointVariant;
    }

    public UpdateThemeRequest loadingPageTouchPointVariant(LoadingPageTouchPointVariant loadingPageTouchPointVariant) {

        this.loadingPageTouchPointVariant = loadingPageTouchPointVariant;
        return this;
    }

    /**
     * Get loadingPageTouchPointVariant
     *
     * @return loadingPageTouchPointVariant
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LOADING_PAGE_TOUCH_POINT_VARIANT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LoadingPageTouchPointVariant getLoadingPageTouchPointVariant() {
        return loadingPageTouchPointVariant;
    }

    @JsonProperty(JSON_PROPERTY_LOADING_PAGE_TOUCH_POINT_VARIANT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLoadingPageTouchPointVariant(LoadingPageTouchPointVariant loadingPageTouchPointVariant) {
        this.loadingPageTouchPointVariant = loadingPageTouchPointVariant;
    }

    public UpdateThemeRequest primaryColorContrastHex(String primaryColorContrastHex) {

        this.primaryColorContrastHex = primaryColorContrastHex;
        return this;
    }

    /**
     * Primary color contrast hex code
     *
     * @return primaryColorContrastHex
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Primary color contrast hex code")
    @JsonProperty(JSON_PROPERTY_PRIMARY_COLOR_CONTRAST_HEX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPrimaryColorContrastHex() {
        return primaryColorContrastHex;
    }

    @JsonProperty(JSON_PROPERTY_PRIMARY_COLOR_CONTRAST_HEX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPrimaryColorContrastHex(String primaryColorContrastHex) {
        this.primaryColorContrastHex = primaryColorContrastHex;
    }

    public UpdateThemeRequest primaryColorHex(String primaryColorHex) {

        this.primaryColorHex = primaryColorHex;
        return this;
    }

    /**
     * Primary color hex code
     *
     * @return primaryColorHex
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Primary color hex code")
    @JsonProperty(JSON_PROPERTY_PRIMARY_COLOR_HEX)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getPrimaryColorHex() {
        return primaryColorHex;
    }

    @JsonProperty(JSON_PROPERTY_PRIMARY_COLOR_HEX)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setPrimaryColorHex(String primaryColorHex) {
        this.primaryColorHex = primaryColorHex;
    }

    public UpdateThemeRequest secondaryColorContrastHex(String secondaryColorContrastHex) {

        this.secondaryColorContrastHex = secondaryColorContrastHex;
        return this;
    }

    /**
     * Secondary color contrast hex code
     *
     * @return secondaryColorContrastHex
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Secondary color contrast hex code")
    @JsonProperty(JSON_PROPERTY_SECONDARY_COLOR_CONTRAST_HEX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSecondaryColorContrastHex() {
        return secondaryColorContrastHex;
    }

    @JsonProperty(JSON_PROPERTY_SECONDARY_COLOR_CONTRAST_HEX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSecondaryColorContrastHex(String secondaryColorContrastHex) {
        this.secondaryColorContrastHex = secondaryColorContrastHex;
    }

    public UpdateThemeRequest secondaryColorHex(String secondaryColorHex) {

        this.secondaryColorHex = secondaryColorHex;
        return this;
    }

    /**
     * Secondary color hex code
     *
     * @return secondaryColorHex
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Secondary color hex code")
    @JsonProperty(JSON_PROPERTY_SECONDARY_COLOR_HEX)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getSecondaryColorHex() {
        return secondaryColorHex;
    }

    @JsonProperty(JSON_PROPERTY_SECONDARY_COLOR_HEX)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSecondaryColorHex(String secondaryColorHex) {
        this.secondaryColorHex = secondaryColorHex;
    }

    public UpdateThemeRequest signInPageTouchPointVariant(SignInPageTouchPointVariant signInPageTouchPointVariant) {

        this.signInPageTouchPointVariant = signInPageTouchPointVariant;
        return this;
    }

    /**
     * Get signInPageTouchPointVariant
     *
     * @return signInPageTouchPointVariant
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_SIGN_IN_PAGE_TOUCH_POINT_VARIANT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public SignInPageTouchPointVariant getSignInPageTouchPointVariant() {
        return signInPageTouchPointVariant;
    }

    @JsonProperty(JSON_PROPERTY_SIGN_IN_PAGE_TOUCH_POINT_VARIANT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSignInPageTouchPointVariant(SignInPageTouchPointVariant signInPageTouchPointVariant) {
        this.signInPageTouchPointVariant = signInPageTouchPointVariant;
    }

    public UpdateThemeRequest links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateThemeRequest updateThemeRequest = (UpdateThemeRequest) o;
        return Objects.equals(this.emailTemplateTouchPointVariant, updateThemeRequest.emailTemplateTouchPointVariant)
                && Objects.equals(this.endUserDashboardTouchPointVariant,
                        updateThemeRequest.endUserDashboardTouchPointVariant)
                && Objects.equals(this.errorPageTouchPointVariant, updateThemeRequest.errorPageTouchPointVariant)
                && Objects.equals(this.loadingPageTouchPointVariant, updateThemeRequest.loadingPageTouchPointVariant)
                && Objects.equals(this.primaryColorContrastHex, updateThemeRequest.primaryColorContrastHex)
                && Objects.equals(this.primaryColorHex, updateThemeRequest.primaryColorHex)
                && Objects.equals(this.secondaryColorContrastHex, updateThemeRequest.secondaryColorContrastHex)
                && Objects.equals(this.secondaryColorHex, updateThemeRequest.secondaryColorHex)
                && Objects.equals(this.signInPageTouchPointVariant, updateThemeRequest.signInPageTouchPointVariant)
                && Objects.equals(this.links, updateThemeRequest.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(emailTemplateTouchPointVariant, endUserDashboardTouchPointVariant,
                errorPageTouchPointVariant, loadingPageTouchPointVariant, primaryColorContrastHex, primaryColorHex,
                secondaryColorContrastHex, secondaryColorHex, signInPageTouchPointVariant, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateThemeRequest {\n");
        sb.append("    emailTemplateTouchPointVariant: ").append(toIndentedString(emailTemplateTouchPointVariant))
                .append("\n");
        sb.append("    endUserDashboardTouchPointVariant: ").append(toIndentedString(endUserDashboardTouchPointVariant))
                .append("\n");
        sb.append("    errorPageTouchPointVariant: ").append(toIndentedString(errorPageTouchPointVariant)).append("\n");
        sb.append("    loadingPageTouchPointVariant: ").append(toIndentedString(loadingPageTouchPointVariant))
                .append("\n");
        sb.append("    primaryColorContrastHex: ").append(toIndentedString(primaryColorContrastHex)).append("\n");
        sb.append("    primaryColorHex: ").append(toIndentedString(primaryColorHex)).append("\n");
        sb.append("    secondaryColorContrastHex: ").append(toIndentedString(secondaryColorContrastHex)).append("\n");
        sb.append("    secondaryColorHex: ").append(toIndentedString(secondaryColorHex)).append("\n");
        sb.append("    signInPageTouchPointVariant: ").append(toIndentedString(signInPageTouchPointVariant))
                .append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
