package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UI Schema element options object
 */
@ApiModel(description = "UI Schema element options object")
@JsonPropertyOrder({ UIElementOptions.JSON_PROPERTY_FORMAT })
@JsonTypeName("UIElement_options")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UIElementOptions implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Specifies how the input appears
     */
    public enum FormatEnum {
        TEXT(String.valueOf("text")),

        RADIO(String.valueOf("radio")),

        SELECT(String.valueOf("select")),

        CHECKBOX(String.valueOf("checkbox")),

        RADIO_YES_NO(String.valueOf("radio_yes_no")),

        RADIO_TRUE_FALSE(String.valueOf("radio_true_false")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        FormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_FORMAT = "format";
    private FormatEnum format;

    public UIElementOptions() {
    }

    public UIElementOptions format(FormatEnum format) {

        this.format = format;
        return this;
    }

    /**
     * Specifies how the input appears
     *
     * @return format
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies how the input appears")
    @JsonProperty(JSON_PROPERTY_FORMAT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FormatEnum getFormat() {
        return format;
    }

    @JsonProperty(JSON_PROPERTY_FORMAT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UIElementOptions uiElementOptions = (UIElementOptions) o;
        return Objects.equals(this.format, uiElementOptions.format);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(format);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UIElementOptions {\n");
        sb.append("    format: ").append(toIndentedString(format)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
