package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.LinksSelfAndLifecycle;
import com.okta.sdk.resource.model.TrustedOriginScope;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * TrustedOrigin
 */
@JsonPropertyOrder({ TrustedOrigin.JSON_PROPERTY_CREATED, TrustedOrigin.JSON_PROPERTY_CREATED_BY,
        TrustedOrigin.JSON_PROPERTY_ID, TrustedOrigin.JSON_PROPERTY_LAST_UPDATED,
        TrustedOrigin.JSON_PROPERTY_LAST_UPDATED_BY, TrustedOrigin.JSON_PROPERTY_NAME,
        TrustedOrigin.JSON_PROPERTY_ORIGIN, TrustedOrigin.JSON_PROPERTY_SCOPES, TrustedOrigin.JSON_PROPERTY_STATUS,
        TrustedOrigin.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class TrustedOrigin implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    private String createdBy;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_LAST_UPDATED_BY = "lastUpdatedBy";
    private String lastUpdatedBy;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_ORIGIN = "origin";
    private String origin;

    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<TrustedOriginScope> scopes = null;

    public static final String JSON_PROPERTY_STATUS = "status";
    private LifecycleStatus status;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelfAndLifecycle links;

    public TrustedOrigin() {
    }

    /*
     * @JsonCreator public TrustedOrigin(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.lastUpdated = lastUpdated; }
     */

    /**
     * Timestamp when the Trusted Origin was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Trusted Origin was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    public TrustedOrigin createdBy(String createdBy) {

        this.createdBy = createdBy;
        return this;
    }

    /**
     * The ID of the user who created the Trusted Origin
     *
     * @return createdBy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ID of the user who created the Trusted Origin")
    @JsonProperty(JSON_PROPERTY_CREATED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreatedBy() {
        return createdBy;
    }

    @JsonProperty(JSON_PROPERTY_CREATED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    /**
     * Unique identifier for the Trusted Origin
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique identifier for the Trusted Origin")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the Trusted Origin was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Trusted Origin was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public TrustedOrigin lastUpdatedBy(String lastUpdatedBy) {

        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    /**
     * The ID of the user who last updated the Trusted Origin
     *
     * @return lastUpdatedBy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ID of the user who last updated the Trusted Origin")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdatedBy() {
        return lastUpdatedBy;
    }

    @JsonProperty(JSON_PROPERTY_LAST_UPDATED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public TrustedOrigin name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Unique name for the Trusted Origin
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique name for the Trusted Origin")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public TrustedOrigin origin(String origin) {

        this.origin = origin;
        return this;
    }

    /**
     * Unique origin URL for the Trusted Origin. The supported schemes for this attribute are HTTP, HTTPS, FTP, Ionic 2,
     * and Capacitor.
     *
     * @return origin
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique origin URL for the Trusted Origin. The supported schemes for this attribute are HTTP, HTTPS, FTP, Ionic 2, and Capacitor.")
    @JsonProperty(JSON_PROPERTY_ORIGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOrigin() {
        return origin;
    }

    @JsonProperty(JSON_PROPERTY_ORIGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public TrustedOrigin scopes(List<TrustedOriginScope> scopes) {

        this.scopes = scopes;
        return this;
    }

    public TrustedOrigin addscopesItem(TrustedOriginScope scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    /**
     * Array of Scope types that this Trusted Origin is used for
     *
     * @return scopes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Array of Scope types that this Trusted Origin is used for")
    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<TrustedOriginScope> getScopes() {
        return scopes;
    }

    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<TrustedOriginScope> scopes) {
        this.scopes = scopes;
    }

    public TrustedOrigin status(LifecycleStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(LifecycleStatus status) {
        this.status = status;
    }

    public TrustedOrigin links(LinksSelfAndLifecycle links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelfAndLifecycle getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelfAndLifecycle links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TrustedOrigin trustedOrigin = (TrustedOrigin) o;
        return Objects.equals(this.created, trustedOrigin.created)
                && Objects.equals(this.createdBy, trustedOrigin.createdBy) && Objects.equals(this.id, trustedOrigin.id)
                && Objects.equals(this.lastUpdated, trustedOrigin.lastUpdated)
                && Objects.equals(this.lastUpdatedBy, trustedOrigin.lastUpdatedBy)
                && Objects.equals(this.name, trustedOrigin.name) && Objects.equals(this.origin, trustedOrigin.origin)
                && Objects.equals(this.scopes, trustedOrigin.scopes)
                && Objects.equals(this.status, trustedOrigin.status) && Objects.equals(this.links, trustedOrigin.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, createdBy, id, lastUpdated, lastUpdatedBy, name, origin, scopes, status, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrustedOrigin {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    lastUpdatedBy: ").append(toIndentedString(lastUpdatedBy)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
        sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
