package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorMethodAlgorithm;
import com.okta.sdk.resource.model.AuthenticatorMethodTransactionType;
import com.okta.sdk.resource.model.PushMethodKeyProtection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SupportedMethodsSettings
 */
@JsonPropertyOrder({ SupportedMethodsSettings.JSON_PROPERTY_KEY_PROTECTION,
        SupportedMethodsSettings.JSON_PROPERTY_ALGORITHMS, SupportedMethodsSettings.JSON_PROPERTY_TRANSACTION_TYPES })
@JsonTypeName("SupportedMethods_settings")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SupportedMethodsSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_KEY_PROTECTION = "keyProtection";
    private PushMethodKeyProtection keyProtection;

    public static final String JSON_PROPERTY_ALGORITHMS = "algorithms";
    private List<AuthenticatorMethodAlgorithm> algorithms = null;

    public static final String JSON_PROPERTY_TRANSACTION_TYPES = "transactionTypes";
    private List<AuthenticatorMethodTransactionType> transactionTypes = null;

    public SupportedMethodsSettings() {
    }

    public SupportedMethodsSettings keyProtection(PushMethodKeyProtection keyProtection) {

        this.keyProtection = keyProtection;
        return this;
    }

    /**
     * Get keyProtection
     *
     * @return keyProtection
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_KEY_PROTECTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PushMethodKeyProtection getKeyProtection() {
        return keyProtection;
    }

    @JsonProperty(JSON_PROPERTY_KEY_PROTECTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKeyProtection(PushMethodKeyProtection keyProtection) {
        this.keyProtection = keyProtection;
    }

    public SupportedMethodsSettings algorithms(List<AuthenticatorMethodAlgorithm> algorithms) {

        this.algorithms = algorithms;
        return this;
    }

    public SupportedMethodsSettings addalgorithmsItem(AuthenticatorMethodAlgorithm algorithmsItem) {
        if (this.algorithms == null) {
            this.algorithms = new ArrayList<>();
        }
        this.algorithms.add(algorithmsItem);
        return this;
    }

    /**
     * The encryption algorithm for this authenticator method
     *
     * @return algorithms
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The encryption algorithm for this authenticator method")
    @JsonProperty(JSON_PROPERTY_ALGORITHMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<AuthenticatorMethodAlgorithm> getAlgorithms() {
        return algorithms;
    }

    @JsonProperty(JSON_PROPERTY_ALGORITHMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithms(List<AuthenticatorMethodAlgorithm> algorithms) {
        this.algorithms = algorithms;
    }

    public SupportedMethodsSettings transactionTypes(List<AuthenticatorMethodTransactionType> transactionTypes) {

        this.transactionTypes = transactionTypes;
        return this;
    }

    public SupportedMethodsSettings addtransactionTypesItem(AuthenticatorMethodTransactionType transactionTypesItem) {
        if (this.transactionTypes == null) {
            this.transactionTypes = new ArrayList<>();
        }
        this.transactionTypes.add(transactionTypesItem);
        return this;
    }

    /**
     * The transaction type for this authenticator method
     *
     * @return transactionTypes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The transaction type for this authenticator method")
    @JsonProperty(JSON_PROPERTY_TRANSACTION_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<AuthenticatorMethodTransactionType> getTransactionTypes() {
        return transactionTypes;
    }

    @JsonProperty(JSON_PROPERTY_TRANSACTION_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionTypes(List<AuthenticatorMethodTransactionType> transactionTypes) {
        this.transactionTypes = transactionTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SupportedMethodsSettings supportedMethodsSettings = (SupportedMethodsSettings) o;
        return Objects.equals(this.keyProtection, supportedMethodsSettings.keyProtection)
                && Objects.equals(this.algorithms, supportedMethodsSettings.algorithms)
                && Objects.equals(this.transactionTypes, supportedMethodsSettings.transactionTypes);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(keyProtection, algorithms, transactionTypes);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SupportedMethodsSettings {\n");
        sb.append("    keyProtection: ").append(toIndentedString(keyProtection)).append("\n");
        sb.append("    algorithms: ").append(toIndentedString(algorithms)).append("\n");
        sb.append("    transactionTypes: ").append(toIndentedString(transactionTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
