package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.LinksAssignee;
import com.okta.sdk.resource.model.RoleAssignmentType;
import com.okta.sdk.resource.model.RoleType;
import com.okta.sdk.resource.model.StandardRoleEmbedded;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * StandardRole
 */
@JsonPropertyOrder({ StandardRole.JSON_PROPERTY_ASSIGNMENT_TYPE, StandardRole.JSON_PROPERTY_CREATED,
        StandardRole.JSON_PROPERTY_ID, StandardRole.JSON_PROPERTY_LABEL, StandardRole.JSON_PROPERTY_LAST_UPDATED,
        StandardRole.JSON_PROPERTY_STATUS, StandardRole.JSON_PROPERTY_TYPE, StandardRole.JSON_PROPERTY_EMBEDDED,
        StandardRole.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class StandardRole implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ASSIGNMENT_TYPE = "assignmentType";
    private RoleAssignmentType assignmentType;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_STATUS = "status";
    private LifecycleStatus status;

    public static final String JSON_PROPERTY_TYPE = "type";
    private RoleType type;

    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private StandardRoleEmbedded embedded;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksAssignee links;

    public StandardRole() {
    }

    /*
     * @JsonCreator public StandardRole(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LABEL) String label,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.label = label; this.lastUpdated = lastUpdated; }
     */

    public StandardRole assignmentType(RoleAssignmentType assignmentType) {

        this.assignmentType = assignmentType;
        return this;
    }

    /**
     * Get assignmentType
     *
     * @return assignmentType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ASSIGNMENT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RoleAssignmentType getAssignmentType() {
        return assignmentType;
    }

    @JsonProperty(JSON_PROPERTY_ASSIGNMENT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAssignmentType(RoleAssignmentType assignmentType) {
        this.assignmentType = assignmentType;
    }

    /**
     * Timestamp when the object was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the object was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * Role Assignment ID
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Role Assignment ID")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Label for the Role Assignment
     *
     * @return label
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Label for the Role Assignment")
    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLabel() {
        return label;
    }

    /**
     * Timestamp when the object was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the object was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public StandardRole status(LifecycleStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(LifecycleStatus status) {
        this.status = status;
    }

    public StandardRole type(RoleType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RoleType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(RoleType type) {
        this.type = type;
    }

    public StandardRole embedded(StandardRoleEmbedded embedded) {

        this.embedded = embedded;
        return this;
    }

    /**
     * Get embedded
     *
     * @return embedded
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public StandardRoleEmbedded getEmbedded() {
        return embedded;
    }

    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEmbedded(StandardRoleEmbedded embedded) {
        this.embedded = embedded;
    }

    public StandardRole links(LinksAssignee links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksAssignee getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksAssignee links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StandardRole standardRole = (StandardRole) o;
        return Objects.equals(this.assignmentType, standardRole.assignmentType)
                && Objects.equals(this.created, standardRole.created) && Objects.equals(this.id, standardRole.id)
                && Objects.equals(this.label, standardRole.label)
                && Objects.equals(this.lastUpdated, standardRole.lastUpdated)
                && Objects.equals(this.status, standardRole.status) && Objects.equals(this.type, standardRole.type)
                && Objects.equals(this.embedded, standardRole.embedded)
                && Objects.equals(this.links, standardRole.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(assignmentType, created, id, label, lastUpdated, status, type, embedded, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StandardRole {\n");
        sb.append("    assignmentType: ").append(toIndentedString(assignmentType)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
