package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Slack app instance properties
 */
@ApiModel(description = "Slack app instance properties")
@JsonPropertyOrder({ SlackApplicationSettingsApplication.JSON_PROPERTY_DOMAIN,
        SlackApplicationSettingsApplication.JSON_PROPERTY_USER_EMAIL_VALUE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SlackApplicationSettingsApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;

    public static final String JSON_PROPERTY_USER_EMAIL_VALUE = "userEmailValue";
    private String userEmailValue;

    public SlackApplicationSettingsApplication() {
    }

    public SlackApplicationSettingsApplication domain(String domain) {

        this.domain = domain;
        return this;
    }

    /**
     * The Slack app domain name
     *
     * @return domain
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The Slack app domain name")
    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getDomain() {
        return domain;
    }

    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public SlackApplicationSettingsApplication userEmailValue(String userEmailValue) {

        this.userEmailValue = userEmailValue;
        return this;
    }

    /**
     * The &#x60;User.Email&#x60; attribute value
     *
     * @return userEmailValue
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `User.Email` attribute value")
    @JsonProperty(JSON_PROPERTY_USER_EMAIL_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserEmailValue() {
        return userEmailValue;
    }

    @JsonProperty(JSON_PROPERTY_USER_EMAIL_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserEmailValue(String userEmailValue) {
        this.userEmailValue = userEmailValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SlackApplicationSettingsApplication slackApplicationSettingsApplication = (SlackApplicationSettingsApplication) o;
        return Objects.equals(this.domain, slackApplicationSettingsApplication.domain)
                && Objects.equals(this.userEmailValue, slackApplicationSettingsApplication.userEmailValue);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(domain, userEmailValue);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SlackApplicationSettingsApplication {\n");
        sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
        sb.append("    userEmailValue: ").append(toIndentedString(userEmailValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
