package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PolicyAccess;
import com.okta.sdk.resource.model.SsprRequirement;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Enables or disables users to reset their own password and defines the authenticators and constraints needed to
 * complete the reset
 */
@ApiModel(description = "Enables or disables users to reset their own password and defines the authenticators and constraints needed to complete the reset")
@JsonPropertyOrder({ SelfServicePasswordResetAction.JSON_PROPERTY_ACCESS,
        SelfServicePasswordResetAction.JSON_PROPERTY_REQUIREMENT, SelfServicePasswordResetAction.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SelfServicePasswordResetAction implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACCESS = "access";
    private PolicyAccess access;

    public static final String JSON_PROPERTY_REQUIREMENT = "requirement";
    private SsprRequirement requirement;

    /**
     * &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt; The type of rule action
     */
    public enum TypeEnum {
        SELF_SERVICE_PASSWORD_RESET(String.valueOf("selfServicePasswordReset")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public SelfServicePasswordResetAction() {
    }

    public SelfServicePasswordResetAction access(PolicyAccess access) {

        this.access = access;
        return this;
    }

    /**
     * Get access
     *
     * @return access
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACCESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyAccess getAccess() {
        return access;
    }

    @JsonProperty(JSON_PROPERTY_ACCESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAccess(PolicyAccess access) {
        this.access = access;
    }

    public SelfServicePasswordResetAction requirement(SsprRequirement requirement) {

        this.requirement = requirement;
        return this;
    }

    /**
     * Get requirement
     *
     * @return requirement
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REQUIREMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SsprRequirement getRequirement() {
        return requirement;
    }

    @JsonProperty(JSON_PROPERTY_REQUIREMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequirement(SsprRequirement requirement) {
        this.requirement = requirement;
    }

    public SelfServicePasswordResetAction type(TypeEnum type) {

        this.type = type;
        return this;
    }

    /**
     * &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt; The type of rule action
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "<x-lifecycle class=\"oie\"></x-lifecycle> The type of rule action")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TypeEnum getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SelfServicePasswordResetAction selfServicePasswordResetAction = (SelfServicePasswordResetAction) o;
        return Objects.equals(this.access, selfServicePasswordResetAction.access)
                && Objects.equals(this.requirement, selfServicePasswordResetAction.requirement)
                && Objects.equals(this.type, selfServicePasswordResetAction.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(access, requirement, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SelfServicePasswordResetAction {\n");
        sb.append("    access: ").append(toIndentedString(access)).append("\n");
        sb.append("    requirement: ").append(toIndentedString(requirement)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
