package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SamlSigningCredentials;
import com.okta.sdk.resource.model.SamlTrustCredentials;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Federation Trust Credentials for verifying assertions from the IdP and signing requests to the IdP
 */
@ApiModel(description = "Federation Trust Credentials for verifying assertions from the IdP and signing requests to the IdP")
@JsonPropertyOrder({ SamlCredentials.JSON_PROPERTY_SIGNING, SamlCredentials.JSON_PROPERTY_TRUST })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SamlCredentials implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SIGNING = "signing";
    private SamlSigningCredentials signing;

    public static final String JSON_PROPERTY_TRUST = "trust";
    private SamlTrustCredentials trust;

    public SamlCredentials() {
    }

    public SamlCredentials signing(SamlSigningCredentials signing) {

        this.signing = signing;
        return this;
    }

    /**
     * Get signing
     *
     * @return signing
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SIGNING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SamlSigningCredentials getSigning() {
        return signing;
    }

    @JsonProperty(JSON_PROPERTY_SIGNING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSigning(SamlSigningCredentials signing) {
        this.signing = signing;
    }

    public SamlCredentials trust(SamlTrustCredentials trust) {

        this.trust = trust;
        return this;
    }

    /**
     * Get trust
     *
     * @return trust
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TRUST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SamlTrustCredentials getTrust() {
        return trust;
    }

    @JsonProperty(JSON_PROPERTY_TRUST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTrust(SamlTrustCredentials trust) {
        this.trust = trust;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SamlCredentials samlCredentials = (SamlCredentials) o;
        return Objects.equals(this.signing, samlCredentials.signing)
                && Objects.equals(this.trust, samlCredentials.trust);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(signing, trust);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlCredentials {\n");
        sb.append("    signing: ").append(toIndentedString(signing)).append("\n");
        sb.append("    trust: ").append(toIndentedString(trust)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
