package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationSettingsNotes;
import com.okta.sdk.resource.model.ApplicationSettingsNotifications;
import com.okta.sdk.resource.model.OINSaml20ApplicationSettingsSignOn;
import com.okta.sdk.resource.model.SalesforceApplicationSettingsApplication;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SalesforceApplicationSettings
 */
@JsonPropertyOrder({ SalesforceApplicationSettings.JSON_PROPERTY_IDENTITY_STORE_ID,
        SalesforceApplicationSettings.JSON_PROPERTY_IMPLICIT_ASSIGNMENT,
        SalesforceApplicationSettings.JSON_PROPERTY_INLINE_HOOK_ID, SalesforceApplicationSettings.JSON_PROPERTY_NOTES,
        SalesforceApplicationSettings.JSON_PROPERTY_NOTIFICATIONS, SalesforceApplicationSettings.JSON_PROPERTY_SIGN_ON,
        SalesforceApplicationSettings.JSON_PROPERTY_APP })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SalesforceApplicationSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_IDENTITY_STORE_ID = "identityStoreId";
    private String identityStoreId;

    public static final String JSON_PROPERTY_IMPLICIT_ASSIGNMENT = "implicitAssignment";
    private Boolean implicitAssignment;

    public static final String JSON_PROPERTY_INLINE_HOOK_ID = "inlineHookId";
    private String inlineHookId;

    public static final String JSON_PROPERTY_NOTES = "notes";
    private ApplicationSettingsNotes notes;

    public static final String JSON_PROPERTY_NOTIFICATIONS = "notifications";
    private ApplicationSettingsNotifications notifications;

    public static final String JSON_PROPERTY_SIGN_ON = "signOn";
    private OINSaml20ApplicationSettingsSignOn signOn;

    public static final String JSON_PROPERTY_APP = "app";
    private SalesforceApplicationSettingsApplication app;

    public SalesforceApplicationSettings() {
    }

    public SalesforceApplicationSettings identityStoreId(String identityStoreId) {

        this.identityStoreId = identityStoreId;
        return this;
    }

    /**
     * Identifies an additional identity store app, if your app supports it. The &#x60;identityStoreId&#x60; value must
     * be a valid identity store app ID. This identity store app must be created in the same org as your app.
     *
     * @return identityStoreId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Identifies an additional identity store app, if your app supports it. The `identityStoreId` value must be a valid identity store app ID. This identity store app must be created in the same org as your app.")
    @JsonProperty(JSON_PROPERTY_IDENTITY_STORE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIdentityStoreId() {
        return identityStoreId;
    }

    @JsonProperty(JSON_PROPERTY_IDENTITY_STORE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIdentityStoreId(String identityStoreId) {
        this.identityStoreId = identityStoreId;
    }

    public SalesforceApplicationSettings implicitAssignment(Boolean implicitAssignment) {

        this.implicitAssignment = implicitAssignment;
        return this;
    }

    /**
     * Controls whether Okta automatically assigns users to the app based on the user&#39;s role or group membership.
     *
     * @return implicitAssignment
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Controls whether Okta automatically assigns users to the app based on the user's role or group membership.")
    @JsonProperty(JSON_PROPERTY_IMPLICIT_ASSIGNMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getImplicitAssignment() {
        return implicitAssignment;
    }

    @JsonProperty(JSON_PROPERTY_IMPLICIT_ASSIGNMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setImplicitAssignment(Boolean implicitAssignment) {
        this.implicitAssignment = implicitAssignment;
    }

    public SalesforceApplicationSettings inlineHookId(String inlineHookId) {

        this.inlineHookId = inlineHookId;
        return this;
    }

    /**
     * Identifier of an inline hook. Inline hooks are outbound calls from Okta to your own custom code, triggered at
     * specific points in Okta process flows. They allow you to integrate custom functionality into those flows. See
     * [Inline hooks](/openapi/okta-management/management/tag/InlineHook/).
     *
     * @return inlineHookId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Identifier of an inline hook. Inline hooks are outbound calls from Okta to your own custom code, triggered at specific points in Okta process flows. They allow you to integrate custom functionality into those flows. See [Inline hooks](/openapi/okta-management/management/tag/InlineHook/).")
    @JsonProperty(JSON_PROPERTY_INLINE_HOOK_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getInlineHookId() {
        return inlineHookId;
    }

    @JsonProperty(JSON_PROPERTY_INLINE_HOOK_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInlineHookId(String inlineHookId) {
        this.inlineHookId = inlineHookId;
    }

    public SalesforceApplicationSettings notes(ApplicationSettingsNotes notes) {

        this.notes = notes;
        return this;
    }

    /**
     * Get notes
     *
     * @return notes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NOTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationSettingsNotes getNotes() {
        return notes;
    }

    @JsonProperty(JSON_PROPERTY_NOTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNotes(ApplicationSettingsNotes notes) {
        this.notes = notes;
    }

    public SalesforceApplicationSettings notifications(ApplicationSettingsNotifications notifications) {

        this.notifications = notifications;
        return this;
    }

    /**
     * Get notifications
     *
     * @return notifications
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NOTIFICATIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationSettingsNotifications getNotifications() {
        return notifications;
    }

    @JsonProperty(JSON_PROPERTY_NOTIFICATIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNotifications(ApplicationSettingsNotifications notifications) {
        this.notifications = notifications;
    }

    public SalesforceApplicationSettings signOn(OINSaml20ApplicationSettingsSignOn signOn) {

        this.signOn = signOn;
        return this;
    }

    /**
     * Get signOn
     *
     * @return signOn
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SIGN_ON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OINSaml20ApplicationSettingsSignOn getSignOn() {
        return signOn;
    }

    @JsonProperty(JSON_PROPERTY_SIGN_ON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSignOn(OINSaml20ApplicationSettingsSignOn signOn) {
        this.signOn = signOn;
    }

    public SalesforceApplicationSettings app(SalesforceApplicationSettingsApplication app) {

        this.app = app;
        return this;
    }

    /**
     * Get app
     *
     * @return app
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_APP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public SalesforceApplicationSettingsApplication getApp() {
        return app;
    }

    @JsonProperty(JSON_PROPERTY_APP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setApp(SalesforceApplicationSettingsApplication app) {
        this.app = app;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SalesforceApplicationSettings salesforceApplicationSettings = (SalesforceApplicationSettings) o;
        return Objects.equals(this.identityStoreId, salesforceApplicationSettings.identityStoreId)
                && Objects.equals(this.implicitAssignment, salesforceApplicationSettings.implicitAssignment)
                && Objects.equals(this.inlineHookId, salesforceApplicationSettings.inlineHookId)
                && Objects.equals(this.notes, salesforceApplicationSettings.notes)
                && Objects.equals(this.notifications, salesforceApplicationSettings.notifications)
                && Objects.equals(this.signOn, salesforceApplicationSettings.signOn)
                && Objects.equals(this.app, salesforceApplicationSettings.app);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityStoreId, implicitAssignment, inlineHookId, notes, notifications, signOn, app);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SalesforceApplicationSettings {\n");
        sb.append("    identityStoreId: ").append(toIndentedString(identityStoreId)).append("\n");
        sb.append("    implicitAssignment: ").append(toIndentedString(implicitAssignment)).append("\n");
        sb.append("    inlineHookId: ").append(toIndentedString(inlineHookId)).append("\n");
        sb.append("    notes: ").append(toIndentedString(notes)).append("\n");
        sb.append("    notifications: ").append(toIndentedString(notifications)).append("\n");
        sb.append("    signOn: ").append(toIndentedString(signOn)).append("\n");
        sb.append("    app: ").append(toIndentedString(app)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
