package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProvisioningGroupsAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Provisioning settings for a User&#39;s Group memberships
 */
@ApiModel(description = "Provisioning settings for a User's Group memberships")
@JsonPropertyOrder({ ProvisioningGroups.JSON_PROPERTY_ACTION, ProvisioningGroups.JSON_PROPERTY_ASSIGNMENTS,
        ProvisioningGroups.JSON_PROPERTY_FILTER, ProvisioningGroups.JSON_PROPERTY_SOURCE_ATTRIBUTE_NAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ProvisioningGroups implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACTION = "action";
    private ProvisioningGroupsAction action;

    public static final String JSON_PROPERTY_ASSIGNMENTS = "assignments";
    private List<String> assignments = null;

    public static final String JSON_PROPERTY_FILTER = "filter";
    private List<String> filter = null;

    public static final String JSON_PROPERTY_SOURCE_ATTRIBUTE_NAME = "sourceAttributeName";
    private String sourceAttributeName;

    public ProvisioningGroups() {
    }

    public ProvisioningGroups action(ProvisioningGroupsAction action) {

        this.action = action;
        return this;
    }

    /**
     * Get action
     *
     * @return action
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProvisioningGroupsAction getAction() {
        return action;
    }

    @JsonProperty(JSON_PROPERTY_ACTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAction(ProvisioningGroupsAction action) {
        this.action = action;
    }

    public ProvisioningGroups assignments(List<String> assignments) {

        this.assignments = assignments;
        return this;
    }

    public ProvisioningGroups addassignmentsItem(String assignmentsItem) {
        if (this.assignments == null) {
            this.assignments = new ArrayList<>();
        }
        this.assignments.add(assignmentsItem);
        return this;
    }

    /**
     * List of &#x60;OKTA_GROUP&#x60; Group identifiers to add an IdP User as a member with the &#x60;ASSIGN&#x60;
     * action
     *
     * @return assignments
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "List of `OKTA_GROUP` Group identifiers to add an IdP User as a member with the `ASSIGN` action")
    @JsonProperty(JSON_PROPERTY_ASSIGNMENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getAssignments() {
        return assignments;
    }

    @JsonProperty(JSON_PROPERTY_ASSIGNMENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAssignments(List<String> assignments) {
        this.assignments = assignments;
    }

    public ProvisioningGroups filter(List<String> filter) {

        this.filter = filter;
        return this;
    }

    public ProvisioningGroups addfilterItem(String filterItem) {
        if (this.filter == null) {
            this.filter = new ArrayList<>();
        }
        this.filter.add(filterItem);
        return this;
    }

    /**
     * Allowlist of &#x60;OKTA_GROUP&#x60; Group identifiers for the &#x60;APPEND&#x60; or &#x60;SYNC&#x60; provisioning
     * action
     *
     * @return filter
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Allowlist of `OKTA_GROUP` Group identifiers for the `APPEND` or `SYNC` provisioning action")
    @JsonProperty(JSON_PROPERTY_FILTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getFilter() {
        return filter;
    }

    @JsonProperty(JSON_PROPERTY_FILTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFilter(List<String> filter) {
        this.filter = filter;
    }

    public ProvisioningGroups sourceAttributeName(String sourceAttributeName) {

        this.sourceAttributeName = sourceAttributeName;
        return this;
    }

    /**
     * IdP User profile attribute name (case-insensitive) for an array value that contains Group memberships
     *
     * @return sourceAttributeName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Groups", value = "IdP User profile attribute name (case-insensitive) for an array value that contains Group memberships")
    @JsonProperty(JSON_PROPERTY_SOURCE_ATTRIBUTE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSourceAttributeName() {
        return sourceAttributeName;
    }

    @JsonProperty(JSON_PROPERTY_SOURCE_ATTRIBUTE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAttributeName(String sourceAttributeName) {
        this.sourceAttributeName = sourceAttributeName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisioningGroups provisioningGroups = (ProvisioningGroups) o;
        return Objects.equals(this.action, provisioningGroups.action)
                && Objects.equals(this.assignments, provisioningGroups.assignments)
                && Objects.equals(this.filter, provisioningGroups.filter)
                && Objects.equals(this.sourceAttributeName, provisioningGroups.sourceAttributeName);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(action, assignments, filter, sourceAttributeName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProvisioningGroups {\n");
        sb.append("    action: ").append(toIndentedString(action)).append("\n");
        sb.append("    assignments: ").append(toIndentedString(assignments)).append("\n");
        sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
        sb.append("    sourceAttributeName: ").append(toIndentedString(sourceAttributeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
