package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Specifies the User provisioning action during authentication when an IdP User isn&#39;t linked to an existing Okta
 * User. * To successfully provision a new Okta User, you must enable just-in-time (JIT) provisioning in your org
 * security settings. * If the target username isn&#39;t unique or the resulting Okta User profile is missing a required
 * profile attribute, JIT provisioning may fail. * New Okta Users are provisioned with either a &#x60;FEDERATION&#x60;
 * or &#x60;SOCIAL&#x60; authentication provider depending on the IdP type.
 */
public enum ProvisioningAction {

    AUTO("AUTO"),

    DISABLED("DISABLED"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    ProvisioningAction(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static ProvisioningAction fromValue(String value) {
        for (ProvisioningAction b : ProvisioningAction.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
