package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * All Okta orgs contain only one IdP Discovery Policy with an immutable default Rule routing to your org&#39;s sign-in
 * page. Creating or replacing a policy with the &#x60;IDP_DISCOVERY&#x60; type isn&#39;t supported. The following
 * policy types are available with Identity Engine: &#x60;ACCESS_POLICY&#x60;, &#x60;PROFILE_ENROLLMENT&#x60;,
 * &#x60;POST_AUTH_SESSION&#x60;, and &#x60;ENTITY_RISK&#x60;. The &#x60;POST_AUTH_SESSION&#x60;, and
 * &#x60;ENTITY_RISK&#x60; policy types are in &lt;x-lifecycle class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt;.
 * Contact your Okta account team to enable these features.
 */
public enum PolicyType {

    ACCESS_POLICY("ACCESS_POLICY"),

    ENTITY_RISK("ENTITY_RISK"),

    IDP_DISCOVERY("IDP_DISCOVERY"),

    MFA_ENROLL("MFA_ENROLL"),

    OKTA_SIGN_ON("OKTA_SIGN_ON"),

    PASSWORD("PASSWORD"),

    POST_AUTH_SESSION("POST_AUTH_SESSION"),

    PROFILE_ENROLLMENT("PROFILE_ENROLLMENT"),

    RESOURCE_ACCESS("RESOURCE_ACCESS"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    PolicyType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static PolicyType fromValue(String value) {
        for (PolicyType b : PolicyType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
