package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksAerialConsentGranted;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OrgAerialGrantNotFound
 */
@JsonPropertyOrder({ OrgAerialGrantNotFound.JSON_PROPERTY_ACCOUNT_ID, OrgAerialGrantNotFound.JSON_PROPERTY_GRANTED_BY,
        OrgAerialGrantNotFound.JSON_PROPERTY_GRANTED_DATE, OrgAerialGrantNotFound.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OrgAerialGrantNotFound implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACCOUNT_ID = "accountId";
    private String accountId;

    public static final String JSON_PROPERTY_GRANTED_BY = "grantedBy";
    private String grantedBy;

    public static final String JSON_PROPERTY_GRANTED_DATE = "grantedDate";
    private String grantedDate;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksAerialConsentGranted links;

    public OrgAerialGrantNotFound() {
    }

    public OrgAerialGrantNotFound accountId(String accountId) {

        this.accountId = accountId;
        return this;
    }

    /**
     * The unique ID of the Aerial account
     *
     * @return accountId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unique ID of the Aerial account")
    @JsonProperty(JSON_PROPERTY_ACCOUNT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAccountId() {
        return accountId;
    }

    @JsonProperty(JSON_PROPERTY_ACCOUNT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OrgAerialGrantNotFound grantedBy(String grantedBy) {

        this.grantedBy = grantedBy;
        return this;
    }

    /**
     * Principal ID of the user who granted the permission
     *
     * @return grantedBy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "00u23ej02I2RLFxS5406", value = "Principal ID of the user who granted the permission")
    @JsonProperty(JSON_PROPERTY_GRANTED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getGrantedBy() {
        return grantedBy;
    }

    @JsonProperty(JSON_PROPERTY_GRANTED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGrantedBy(String grantedBy) {
        this.grantedBy = grantedBy;
    }

    public OrgAerialGrantNotFound grantedDate(String grantedDate) {

        this.grantedDate = grantedDate;
        return this;
    }

    /**
     * Date when grant was created
     *
     * @return grantedDate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2024-07-24T16:01:13.000Z", value = "Date when grant was created")
    @JsonProperty(JSON_PROPERTY_GRANTED_DATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getGrantedDate() {
        return grantedDate;
    }

    @JsonProperty(JSON_PROPERTY_GRANTED_DATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGrantedDate(String grantedDate) {
        this.grantedDate = grantedDate;
    }

    public OrgAerialGrantNotFound links(LinksAerialConsentGranted links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksAerialConsentGranted getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksAerialConsentGranted links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgAerialGrantNotFound orgAerialGrantNotFound = (OrgAerialGrantNotFound) o;
        return Objects.equals(this.accountId, orgAerialGrantNotFound.accountId)
                && Objects.equals(this.grantedBy, orgAerialGrantNotFound.grantedBy)
                && Objects.equals(this.grantedDate, orgAerialGrantNotFound.grantedDate)
                && Objects.equals(this.links, orgAerialGrantNotFound.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountId, grantedBy, grantedDate, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgAerialGrantNotFound {\n");
        sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
        sb.append("    grantedBy: ").append(toIndentedString(grantedBy)).append("\n");
        sb.append("    grantedDate: ").append(toIndentedString(grantedDate)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
