package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Org2Org app instance properties
 */
@ApiModel(description = "Org2Org app instance properties")
@JsonPropertyOrder({ Org2OrgApplicationSettingsApplication.JSON_PROPERTY_ACS_URL,
        Org2OrgApplicationSettingsApplication.JSON_PROPERTY_AUD_RESTRICTION,
        Org2OrgApplicationSettingsApplication.JSON_PROPERTY_BASE_URL,
        Org2OrgApplicationSettingsApplication.JSON_PROPERTY_CREATION_STATE,
        Org2OrgApplicationSettingsApplication.JSON_PROPERTY_PREFER_USERNAME_OVER_EMAIL,
        Org2OrgApplicationSettingsApplication.JSON_PROPERTY_TOKEN,
        Org2OrgApplicationSettingsApplication.JSON_PROPERTY_TOKEN_ENCRYPTED })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class Org2OrgApplicationSettingsApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACS_URL = "acsUrl";
    private String acsUrl;

    public static final String JSON_PROPERTY_AUD_RESTRICTION = "audRestriction";
    private String audRestriction;

    public static final String JSON_PROPERTY_BASE_URL = "baseUrl";
    private String baseUrl;

    public static final String JSON_PROPERTY_CREATION_STATE = "creationState";
    private String creationState;

    public static final String JSON_PROPERTY_PREFER_USERNAME_OVER_EMAIL = "preferUsernameOverEmail";
    private Boolean preferUsernameOverEmail;

    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;

    public static final String JSON_PROPERTY_TOKEN_ENCRYPTED = "tokenEncrypted";
    private String tokenEncrypted;

    public Org2OrgApplicationSettingsApplication() {
    }

    public Org2OrgApplicationSettingsApplication acsUrl(String acsUrl) {

        this.acsUrl = acsUrl;
        return this;
    }

    /**
     * The Assertion Consumer Service (ACS) URL of the source org (for &#x60;SAML_2_0&#x60; sign-on mode)
     *
     * @return acsUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The Assertion Consumer Service (ACS) URL of the source org (for `SAML_2_0` sign-on mode)")
    @JsonProperty(JSON_PROPERTY_ACS_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAcsUrl() {
        return acsUrl;
    }

    @JsonProperty(JSON_PROPERTY_ACS_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAcsUrl(String acsUrl) {
        this.acsUrl = acsUrl;
    }

    public Org2OrgApplicationSettingsApplication audRestriction(String audRestriction) {

        this.audRestriction = audRestriction;
        return this;
    }

    /**
     * The entity ID of the SP (for &#x60;SAML_2_0&#x60; sign-on mode)
     *
     * @return audRestriction
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://www.okta.com/saml2/service-provider/exampleid", value = "The entity ID of the SP (for `SAML_2_0` sign-on mode)")
    @JsonProperty(JSON_PROPERTY_AUD_RESTRICTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAudRestriction() {
        return audRestriction;
    }

    @JsonProperty(JSON_PROPERTY_AUD_RESTRICTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAudRestriction(String audRestriction) {
        this.audRestriction = audRestriction;
    }

    public Org2OrgApplicationSettingsApplication baseUrl(String baseUrl) {

        this.baseUrl = baseUrl;
        return this;
    }

    /**
     * The base URL of the target Okta org (for &#x60;SAML_2_0&#x60; sign-on mode)
     *
     * @return baseUrl
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The base URL of the target Okta org (for `SAML_2_0` sign-on mode)")
    @JsonProperty(JSON_PROPERTY_BASE_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getBaseUrl() {
        return baseUrl;
    }

    @JsonProperty(JSON_PROPERTY_BASE_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Org2OrgApplicationSettingsApplication creationState(String creationState) {

        this.creationState = creationState;
        return this;
    }

    /**
     * Used to track and manage the state of the app&#39;s creation or the provisioning process between two Okta orgs
     *
     * @return creationState
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Used to track and manage the state of the app's creation or the provisioning process between two Okta orgs")
    @JsonProperty(JSON_PROPERTY_CREATION_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreationState() {
        return creationState;
    }

    @JsonProperty(JSON_PROPERTY_CREATION_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCreationState(String creationState) {
        this.creationState = creationState;
    }

    public Org2OrgApplicationSettingsApplication preferUsernameOverEmail(Boolean preferUsernameOverEmail) {

        this.preferUsernameOverEmail = preferUsernameOverEmail;
        return this;
    }

    /**
     * Indicates that you don&#39;t want to use an email address as the username
     *
     * @return preferUsernameOverEmail
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates that you don't want to use an email address as the username")
    @JsonProperty(JSON_PROPERTY_PREFER_USERNAME_OVER_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getPreferUsernameOverEmail() {
        return preferUsernameOverEmail;
    }

    @JsonProperty(JSON_PROPERTY_PREFER_USERNAME_OVER_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPreferUsernameOverEmail(Boolean preferUsernameOverEmail) {
        this.preferUsernameOverEmail = preferUsernameOverEmail;
    }

    public Org2OrgApplicationSettingsApplication token(String token) {

        this.token = token;
        return this;
    }

    /**
     * An API token from the target org that&#39;s used to secure the connection between the orgs
     *
     * @return token
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An API token from the target org that's used to secure the connection between the orgs")
    @JsonProperty(JSON_PROPERTY_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getToken() {
        return token;
    }

    @JsonProperty(JSON_PROPERTY_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setToken(String token) {
        this.token = token;
    }

    public Org2OrgApplicationSettingsApplication tokenEncrypted(String tokenEncrypted) {

        this.tokenEncrypted = tokenEncrypted;
        return this;
    }

    /**
     * Encrypted token to enhance security
     *
     * @return tokenEncrypted
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Encrypted token to enhance security")
    @JsonProperty(JSON_PROPERTY_TOKEN_ENCRYPTED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTokenEncrypted() {
        return tokenEncrypted;
    }

    @JsonProperty(JSON_PROPERTY_TOKEN_ENCRYPTED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTokenEncrypted(String tokenEncrypted) {
        this.tokenEncrypted = tokenEncrypted;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Org2OrgApplicationSettingsApplication org2OrgApplicationSettingsApplication = (Org2OrgApplicationSettingsApplication) o;
        return Objects.equals(this.acsUrl, org2OrgApplicationSettingsApplication.acsUrl)
                && Objects.equals(this.audRestriction, org2OrgApplicationSettingsApplication.audRestriction)
                && Objects.equals(this.baseUrl, org2OrgApplicationSettingsApplication.baseUrl)
                && Objects.equals(this.creationState, org2OrgApplicationSettingsApplication.creationState)
                && Objects.equals(this.preferUsernameOverEmail,
                        org2OrgApplicationSettingsApplication.preferUsernameOverEmail)
                && Objects.equals(this.token, org2OrgApplicationSettingsApplication.token)
                && Objects.equals(this.tokenEncrypted, org2OrgApplicationSettingsApplication.tokenEncrypted);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(acsUrl, audRestriction, baseUrl, creationState, preferUsernameOverEmail, token,
                tokenEncrypted);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Org2OrgApplicationSettingsApplication {\n");
        sb.append("    acsUrl: ").append(toIndentedString(acsUrl)).append("\n");
        sb.append("    audRestriction: ").append(toIndentedString(audRestriction)).append("\n");
        sb.append("    baseUrl: ").append(toIndentedString(baseUrl)).append("\n");
        sb.append("    creationState: ").append(toIndentedString(creationState)).append("\n");
        sb.append("    preferUsernameOverEmail: ").append(toIndentedString(preferUsernameOverEmail)).append("\n");
        sb.append("    token: ").append(toIndentedString(token)).append("\n");
        sb.append("    tokenEncrypted: ").append(toIndentedString(tokenEncrypted)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
