package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Indicates if the User should be challenged for a second factor (MFA) based on the device being used, a Factor session
 * lifetime, or on every sign-in attempt **Note:** Required only if &#x60;requireFactor&#x60; is set to
 * &#x60;true&#x60;.
 */
public enum OktaSignOnPolicyFactorPromptMode {

    ALWAYS("ALWAYS"),

    DEVICE("DEVICE"),

    SESSION("SESSION"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    OktaSignOnPolicyFactorPromptMode(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static OktaSignOnPolicyFactorPromptMode fromValue(String value) {
        for (OktaSignOnPolicyFactorPromptMode b : OktaSignOnPolicyFactorPromptMode.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
