package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OidcSigningAlgorithm;
import com.okta.sdk.resource.model.ProtocolAlgorithmRequestScope;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Signature Algorithm settings for signing authorization requests sent to the IdP &gt; **Note:** The
 * &#x60;algorithm&#x60; property is ignored when you disable request signatures (&#x60;scope&#x60; set as
 * &#x60;NONE&#x60;).
 */
@ApiModel(description = "Signature Algorithm settings for signing authorization requests sent to the IdP > **Note:**  The `algorithm` property is ignored when you disable request signatures (`scope` set as `NONE`).")
@JsonPropertyOrder({ OidcRequestSignatureAlgorithm.JSON_PROPERTY_ALGORITHM,
        OidcRequestSignatureAlgorithm.JSON_PROPERTY_SCOPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OidcRequestSignatureAlgorithm implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALGORITHM = "algorithm";
    private OidcSigningAlgorithm algorithm;

    public static final String JSON_PROPERTY_SCOPE = "scope";
    private ProtocolAlgorithmRequestScope scope;

    public OidcRequestSignatureAlgorithm() {
    }

    public OidcRequestSignatureAlgorithm algorithm(OidcSigningAlgorithm algorithm) {

        this.algorithm = algorithm;
        return this;
    }

    /**
     * Get algorithm
     *
     * @return algorithm
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ALGORITHM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OidcSigningAlgorithm getAlgorithm() {
        return algorithm;
    }

    @JsonProperty(JSON_PROPERTY_ALGORITHM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithm(OidcSigningAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public OidcRequestSignatureAlgorithm scope(ProtocolAlgorithmRequestScope scope) {

        this.scope = scope;
        return this;
    }

    /**
     * Get scope
     *
     * @return scope
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolAlgorithmRequestScope getScope() {
        return scope;
    }

    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScope(ProtocolAlgorithmRequestScope scope) {
        this.scope = scope;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OidcRequestSignatureAlgorithm oidcRequestSignatureAlgorithm = (OidcRequestSignatureAlgorithm) o;
        return Objects.equals(this.algorithm, oidcRequestSignatureAlgorithm.algorithm)
                && Objects.equals(this.scope, oidcRequestSignatureAlgorithm.scope);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(algorithm, scope);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OidcRequestSignatureAlgorithm {\n");
        sb.append("    algorithm: ").append(toIndentedString(algorithm)).append("\n");
        sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
