package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SamlAttributeStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Contains SAML 2.0 sign-on mode attributes. &gt; **Note:** Set &#x60;destinationOverride&#x60; to configure any other
 * SAML 2.0 attributes in this section.
 */
@ApiModel(description = "Contains SAML 2.0 sign-on mode attributes. > **Note:** Set `destinationOverride` to configure any other SAML 2.0 attributes in this section.")
@JsonPropertyOrder({ OINSaml20ApplicationSettingsSignOn.JSON_PROPERTY_AUDIENCE_OVERRIDE,
        OINSaml20ApplicationSettingsSignOn.JSON_PROPERTY_CONFIGURED_ATTRIBUTE_STATEMENTS,
        OINSaml20ApplicationSettingsSignOn.JSON_PROPERTY_DEFAULT_RELAY_STATE,
        OINSaml20ApplicationSettingsSignOn.JSON_PROPERTY_DESTINATION_OVERRIDE,
        OINSaml20ApplicationSettingsSignOn.JSON_PROPERTY_RECIPIENT_OVERRIDE,
        OINSaml20ApplicationSettingsSignOn.JSON_PROPERTY_SAML_ASSERTION_LIFETIME_SECONDS,
        OINSaml20ApplicationSettingsSignOn.JSON_PROPERTY_SSO_ACS_URL_OVERRIDE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OINSaml20ApplicationSettingsSignOn implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUDIENCE_OVERRIDE = "audienceOverride";
    private String audienceOverride;

    public static final String JSON_PROPERTY_CONFIGURED_ATTRIBUTE_STATEMENTS = "configuredAttributeStatements";
    private List<SamlAttributeStatement> configuredAttributeStatements = null;

    public static final String JSON_PROPERTY_DEFAULT_RELAY_STATE = "defaultRelayState";
    private String defaultRelayState;

    public static final String JSON_PROPERTY_DESTINATION_OVERRIDE = "destinationOverride";
    private String destinationOverride;

    public static final String JSON_PROPERTY_RECIPIENT_OVERRIDE = "recipientOverride";
    private String recipientOverride;

    public static final String JSON_PROPERTY_SAML_ASSERTION_LIFETIME_SECONDS = "samlAssertionLifetimeSeconds";
    private Integer samlAssertionLifetimeSeconds;

    public static final String JSON_PROPERTY_SSO_ACS_URL_OVERRIDE = "ssoAcsUrlOverride";
    private String ssoAcsUrlOverride;

    public OINSaml20ApplicationSettingsSignOn() {
    }

    public OINSaml20ApplicationSettingsSignOn audienceOverride(String audienceOverride) {

        this.audienceOverride = audienceOverride;
        return this;
    }

    /**
     * Audience override for CASB configuration. See [CASB config
     * guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).
     *
     * @return audienceOverride
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Audience override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(JSON_PROPERTY_AUDIENCE_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAudienceOverride() {
        return audienceOverride;
    }

    @JsonProperty(JSON_PROPERTY_AUDIENCE_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAudienceOverride(String audienceOverride) {
        this.audienceOverride = audienceOverride;
    }

    public OINSaml20ApplicationSettingsSignOn configuredAttributeStatements(
            List<SamlAttributeStatement> configuredAttributeStatements) {

        this.configuredAttributeStatements = configuredAttributeStatements;
        return this;
    }

    public OINSaml20ApplicationSettingsSignOn addconfiguredAttributeStatementsItem(
            SamlAttributeStatement configuredAttributeStatementsItem) {
        if (this.configuredAttributeStatements == null) {
            this.configuredAttributeStatements = new ArrayList<>();
        }
        this.configuredAttributeStatements.add(configuredAttributeStatementsItem);
        return this;
    }

    /**
     * Get configuredAttributeStatements
     *
     * @return configuredAttributeStatements
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONFIGURED_ATTRIBUTE_STATEMENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<SamlAttributeStatement> getConfiguredAttributeStatements() {
        return configuredAttributeStatements;
    }

    @JsonProperty(JSON_PROPERTY_CONFIGURED_ATTRIBUTE_STATEMENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConfiguredAttributeStatements(List<SamlAttributeStatement> configuredAttributeStatements) {
        this.configuredAttributeStatements = configuredAttributeStatements;
    }

    public OINSaml20ApplicationSettingsSignOn defaultRelayState(String defaultRelayState) {

        this.defaultRelayState = defaultRelayState;
        return this;
    }

    /**
     * Identifies a specific application resource in an IdP-initiated SSO scenario
     *
     * @return defaultRelayState
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Identifies a specific application resource in an IdP-initiated SSO scenario")
    @JsonProperty(JSON_PROPERTY_DEFAULT_RELAY_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDefaultRelayState() {
        return defaultRelayState;
    }

    @JsonProperty(JSON_PROPERTY_DEFAULT_RELAY_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultRelayState(String defaultRelayState) {
        this.defaultRelayState = defaultRelayState;
    }

    public OINSaml20ApplicationSettingsSignOn destinationOverride(String destinationOverride) {

        this.destinationOverride = destinationOverride;
        return this;
    }

    /**
     * Destination override for CASB configuration. See [CASB config
     * guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).
     *
     * @return destinationOverride
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Destination override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(JSON_PROPERTY_DESTINATION_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDestinationOverride() {
        return destinationOverride;
    }

    @JsonProperty(JSON_PROPERTY_DESTINATION_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationOverride(String destinationOverride) {
        this.destinationOverride = destinationOverride;
    }

    public OINSaml20ApplicationSettingsSignOn recipientOverride(String recipientOverride) {

        this.recipientOverride = recipientOverride;
        return this;
    }

    /**
     * Recipient override for CASB configuration. See [CASB config
     * guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).
     *
     * @return recipientOverride
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Recipient override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(JSON_PROPERTY_RECIPIENT_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRecipientOverride() {
        return recipientOverride;
    }

    @JsonProperty(JSON_PROPERTY_RECIPIENT_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRecipientOverride(String recipientOverride) {
        this.recipientOverride = recipientOverride;
    }

    public OINSaml20ApplicationSettingsSignOn samlAssertionLifetimeSeconds(Integer samlAssertionLifetimeSeconds) {

        this.samlAssertionLifetimeSeconds = samlAssertionLifetimeSeconds;
        return this;
    }

    /**
     * Determines the SAML app session lifetimes with Okta
     *
     * @return samlAssertionLifetimeSeconds
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "3600", value = "Determines the SAML app session lifetimes with Okta")
    @JsonProperty(JSON_PROPERTY_SAML_ASSERTION_LIFETIME_SECONDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getSamlAssertionLifetimeSeconds() {
        return samlAssertionLifetimeSeconds;
    }

    @JsonProperty(JSON_PROPERTY_SAML_ASSERTION_LIFETIME_SECONDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSamlAssertionLifetimeSeconds(Integer samlAssertionLifetimeSeconds) {
        this.samlAssertionLifetimeSeconds = samlAssertionLifetimeSeconds;
    }

    public OINSaml20ApplicationSettingsSignOn ssoAcsUrlOverride(String ssoAcsUrlOverride) {

        this.ssoAcsUrlOverride = ssoAcsUrlOverride;
        return this;
    }

    /**
     * Assertion Consumer Service (ACS) URL override for CASB configuration. See [CASB config
     * guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).
     *
     * @return ssoAcsUrlOverride
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Assertion Consumer Service (ACS) URL override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(JSON_PROPERTY_SSO_ACS_URL_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSsoAcsUrlOverride() {
        return ssoAcsUrlOverride;
    }

    @JsonProperty(JSON_PROPERTY_SSO_ACS_URL_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSsoAcsUrlOverride(String ssoAcsUrlOverride) {
        this.ssoAcsUrlOverride = ssoAcsUrlOverride;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OINSaml20ApplicationSettingsSignOn oiNSaml20ApplicationSettingsSignOn = (OINSaml20ApplicationSettingsSignOn) o;
        return Objects.equals(this.audienceOverride, oiNSaml20ApplicationSettingsSignOn.audienceOverride)
                && Objects.equals(this.configuredAttributeStatements,
                        oiNSaml20ApplicationSettingsSignOn.configuredAttributeStatements)
                && Objects.equals(this.defaultRelayState, oiNSaml20ApplicationSettingsSignOn.defaultRelayState)
                && Objects.equals(this.destinationOverride, oiNSaml20ApplicationSettingsSignOn.destinationOverride)
                && Objects.equals(this.recipientOverride, oiNSaml20ApplicationSettingsSignOn.recipientOverride)
                && Objects.equals(this.samlAssertionLifetimeSeconds,
                        oiNSaml20ApplicationSettingsSignOn.samlAssertionLifetimeSeconds)
                && Objects.equals(this.ssoAcsUrlOverride, oiNSaml20ApplicationSettingsSignOn.ssoAcsUrlOverride);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(audienceOverride, configuredAttributeStatements, defaultRelayState, destinationOverride,
                recipientOverride, samlAssertionLifetimeSeconds, ssoAcsUrlOverride);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OINSaml20ApplicationSettingsSignOn {\n");
        sb.append("    audienceOverride: ").append(toIndentedString(audienceOverride)).append("\n");
        sb.append("    configuredAttributeStatements: ").append(toIndentedString(configuredAttributeStatements))
                .append("\n");
        sb.append("    defaultRelayState: ").append(toIndentedString(defaultRelayState)).append("\n");
        sb.append("    destinationOverride: ").append(toIndentedString(destinationOverride)).append("\n");
        sb.append("    recipientOverride: ").append(toIndentedString(recipientOverride)).append("\n");
        sb.append("    samlAssertionLifetimeSeconds: ").append(toIndentedString(samlAssertionLifetimeSeconds))
                .append("\n");
        sb.append("    ssoAcsUrlOverride: ").append(toIndentedString(ssoAcsUrlOverride)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
