package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Determines the Okta username for the imported user
 */
@ApiModel(description = "Determines the Okta username for the imported user")
@JsonPropertyOrder({ ImportUsernameObject.JSON_PROPERTY_USER_NAME_EXPRESSION,
        ImportUsernameObject.JSON_PROPERTY_USERNAME_FORMAT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ImportUsernameObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_USER_NAME_EXPRESSION = "userNameExpression";
    private String userNameExpression;

    /**
     * Determines the username format when users sign in to Okta
     */
    public enum UsernameFormatEnum {
        EMAIL(String.valueOf("EMAIL")),

        CUSTOM(String.valueOf("CUSTOM")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        UsernameFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static UsernameFormatEnum fromValue(String value) {
            for (UsernameFormatEnum b : UsernameFormatEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_USERNAME_FORMAT = "usernameFormat";
    private UsernameFormatEnum usernameFormat = UsernameFormatEnum.EMAIL;

    public ImportUsernameObject() {
    }

    public ImportUsernameObject userNameExpression(String userNameExpression) {

        this.userNameExpression = userNameExpression;
        return this;
    }

    /**
     * For &#x60;usernameFormat&#x3D;CUSTOM&#x60;, specifies the Okta Expression Language statement for a username
     * format that imported users use to sign in to Okta
     *
     * @return userNameExpression
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "For `usernameFormat=CUSTOM`, specifies the Okta Expression Language statement for a username format that imported users use to sign in to Okta")
    @JsonProperty(JSON_PROPERTY_USER_NAME_EXPRESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserNameExpression() {
        return userNameExpression;
    }

    @JsonProperty(JSON_PROPERTY_USER_NAME_EXPRESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserNameExpression(String userNameExpression) {
        this.userNameExpression = userNameExpression;
    }

    public ImportUsernameObject usernameFormat(UsernameFormatEnum usernameFormat) {

        this.usernameFormat = usernameFormat;
        return this;
    }

    /**
     * Determines the username format when users sign in to Okta
     *
     * @return usernameFormat
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Determines the username format when users sign in to Okta")
    @JsonProperty(JSON_PROPERTY_USERNAME_FORMAT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public UsernameFormatEnum getUsernameFormat() {
        return usernameFormat;
    }

    @JsonProperty(JSON_PROPERTY_USERNAME_FORMAT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUsernameFormat(UsernameFormatEnum usernameFormat) {
        this.usernameFormat = usernameFormat;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImportUsernameObject importUsernameObject = (ImportUsernameObject) o;
        return Objects.equals(this.userNameExpression, importUsernameObject.userNameExpression)
                && Objects.equals(this.usernameFormat, importUsernameObject.usernameFormat);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(userNameExpression, usernameFormat);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportUsernameObject {\n");
        sb.append("    userNameExpression: ").append(toIndentedString(userNameExpression)).append("\n");
        sb.append("    usernameFormat: ").append(toIndentedString(usernameFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
