package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IdentityProviderIssuerMode;
import com.okta.sdk.resource.model.IdentityProviderLinks;
import com.okta.sdk.resource.model.IdentityProviderPolicy;
import com.okta.sdk.resource.model.IdentityProviderProperties;
import com.okta.sdk.resource.model.IdentityProviderType;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.Protocol;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * IdentityProvider
 */
@JsonPropertyOrder({ IdentityProvider.JSON_PROPERTY_CREATED, IdentityProvider.JSON_PROPERTY_ID,
        IdentityProvider.JSON_PROPERTY_ISSUER_MODE, IdentityProvider.JSON_PROPERTY_LAST_UPDATED,
        IdentityProvider.JSON_PROPERTY_NAME, IdentityProvider.JSON_PROPERTY_POLICY,
        IdentityProvider.JSON_PROPERTY_PROPERTIES, IdentityProvider.JSON_PROPERTY_PROTOCOL,
        IdentityProvider.JSON_PROPERTY_STATUS, IdentityProvider.JSON_PROPERTY_TYPE,
        IdentityProvider.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class IdentityProvider implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_ISSUER_MODE = "issuerMode";
    private IdentityProviderIssuerMode issuerMode = IdentityProviderIssuerMode.DYNAMIC;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_POLICY = "policy";
    private IdentityProviderPolicy policy;

    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private JsonNullable<IdentityProviderProperties> properties = JsonNullable.<IdentityProviderProperties> undefined();

    public static final String JSON_PROPERTY_PROTOCOL = "protocol";
    private Protocol protocol;

    public static final String JSON_PROPERTY_STATUS = "status";
    private LifecycleStatus status;

    public static final String JSON_PROPERTY_TYPE = "type";
    private IdentityProviderType type;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private IdentityProviderLinks links;

    public IdentityProvider() {
    }

    /*
     * @JsonCreator public IdentityProvider(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.lastUpdated = lastUpdated; }
     */

    /**
     * Timestamp when the object was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2016-01-03T18:15:47Z", value = "Timestamp when the object was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * Unique key for the IdP
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "0oaWma58liwx40w6boYD", value = "Unique key for the IdP")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public IdentityProvider issuerMode(IdentityProviderIssuerMode issuerMode) {

        this.issuerMode = issuerMode;
        return this;
    }

    /**
     * Get issuerMode
     *
     * @return issuerMode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ISSUER_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IdentityProviderIssuerMode getIssuerMode() {
        return issuerMode;
    }

    @JsonProperty(JSON_PROPERTY_ISSUER_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerMode(IdentityProviderIssuerMode issuerMode) {
        this.issuerMode = issuerMode;
    }

    /**
     * Timestamp when the object was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2016-01-03T18:15:47Z", value = "Timestamp when the object was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public IdentityProvider name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Unique name for the IdP
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Sample Identity Provider", value = "Unique name for the IdP")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public IdentityProvider policy(IdentityProviderPolicy policy) {

        this.policy = policy;
        return this;
    }

    /**
     * Get policy
     *
     * @return policy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_POLICY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IdentityProviderPolicy getPolicy() {
        return policy;
    }

    @JsonProperty(JSON_PROPERTY_POLICY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(IdentityProviderPolicy policy) {
        this.policy = policy;
    }

    public IdentityProvider properties(IdentityProviderProperties properties) {
        this.properties = JsonNullable.<IdentityProviderProperties> of(properties);

        return this;
    }

    /**
     * Get properties
     *
     * @return properties
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonIgnore

    public IdentityProviderProperties getProperties() {
        return properties.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_PROPERTIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<IdentityProviderProperties> getProperties_JsonNullable() {
        return properties;
    }

    @JsonProperty(JSON_PROPERTY_PROPERTIES)
    public void setProperties_JsonNullable(JsonNullable<IdentityProviderProperties> properties) {
        this.properties = properties;
    }

    public void setProperties(IdentityProviderProperties properties) {
        this.properties = JsonNullable.<IdentityProviderProperties> of(properties);
    }

    public IdentityProvider protocol(Protocol protocol) {

        this.protocol = protocol;
        return this;
    }

    /**
     * Get protocol
     *
     * @return protocol
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROTOCOL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Protocol getProtocol() {
        return protocol;
    }

    @JsonProperty(JSON_PROPERTY_PROTOCOL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public IdentityProvider status(LifecycleStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(LifecycleStatus status) {
        this.status = status;
    }

    public IdentityProvider type(IdentityProviderType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IdentityProviderType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(IdentityProviderType type) {
        this.type = type;
    }

    public IdentityProvider links(IdentityProviderLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IdentityProviderLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(IdentityProviderLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdentityProvider identityProvider = (IdentityProvider) o;
        return Objects.equals(this.created, identityProvider.created) && Objects.equals(this.id, identityProvider.id)
                && Objects.equals(this.issuerMode, identityProvider.issuerMode)
                && Objects.equals(this.lastUpdated, identityProvider.lastUpdated)
                && Objects.equals(this.name, identityProvider.name)
                && Objects.equals(this.policy, identityProvider.policy)
                && equalsNullable(this.properties, identityProvider.properties)
                && Objects.equals(this.protocol, identityProvider.protocol)
                && Objects.equals(this.status, identityProvider.status)
                && Objects.equals(this.type, identityProvider.type)
                && Objects.equals(this.links, identityProvider.links);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, id, issuerMode, lastUpdated, name, policy, hashCodeNullable(properties), protocol,
                status, type, links);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityProvider {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    issuerMode: ").append(toIndentedString(issuerMode)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
        sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
        sb.append("    protocol: ").append(toIndentedString(protocol)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
